/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.plugin.framework.entity.DiscoveryEntity;
import com.nepxion.discovery.plugin.framework.entity.DiscoveryServiceEntity;
import com.nepxion.discovery.plugin.framework.entity.RuleEntity;
import com.nepxion.discovery.plugin.framework.entity.VersionFilterEntity;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class VersionFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        String consumerServiceId = this.pluginAdapter.getServiceId();
        String consumerServiceVersion = this.pluginAdapter.getVersion();
        this.applyVersionFilter(consumerServiceId, consumerServiceVersion, serviceId, servers);
    }

    private void applyVersionFilter(String consumerServiceId, String consumerServiceVersion, String providerServiceId, List<? extends Server> servers) {
        if (StringUtils.isEmpty((CharSequence)consumerServiceVersion)) {
            return;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        if (versionFilterEntity == null) {
            return;
        }
        Map<String, List<DiscoveryServiceEntity>> serviceEntityMap = versionFilterEntity.getServiceEntityMap();
        if (MapUtils.isEmpty(serviceEntityMap)) {
            return;
        }
        List<DiscoveryServiceEntity> serviceEntityList = serviceEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty(serviceEntityList)) {
            return;
        }
        ArrayList<String> allNoFilterValueList = null;
        boolean providerConditionDefined = false;
        for (DiscoveryServiceEntity serviceEntity : serviceEntityList) {
            String providerServiceName = serviceEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            providerConditionDefined = true;
            List<String> consumerVersionValueList = serviceEntity.getConsumerVersionValueList();
            List<String> providerVersionValueList = serviceEntity.getProviderVersionValueList();
            if (CollectionUtils.isNotEmpty(consumerVersionValueList)) {
                if (!consumerVersionValueList.contains(consumerServiceVersion)) continue;
                if (allNoFilterValueList == null) {
                    allNoFilterValueList = new ArrayList();
                }
                if (!CollectionUtils.isNotEmpty(providerVersionValueList)) continue;
                allNoFilterValueList.addAll(providerVersionValueList);
                continue;
            }
            if (allNoFilterValueList == null) {
                allNoFilterValueList = new ArrayList<String>();
            }
            if (!CollectionUtils.isNotEmpty(providerVersionValueList)) continue;
            allNoFilterValueList.addAll(providerVersionValueList);
        }
        if (allNoFilterValueList != null) {
            if (allNoFilterValueList.isEmpty()) {
                return;
            }
            Iterator<? extends Server> iterator = servers.iterator();
            while (iterator.hasNext()) {
                Server server = iterator.next();
                String metadataVersion = this.pluginAdapter.getServerVersion(server);
                if (allNoFilterValueList.contains(metadataVersion)) continue;
                iterator.remove();
            }
        } else if (providerConditionDefined) {
            servers.clear();
        }
    }
}

