/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.biz.common.util;

import com.netfinworks.common.lang.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class PropertyConverter {
    private static final String DEFAULT_EQUALS = "=";
    private static final String DEFAULT_SPLIT = ";";

    public static String convertFromMap(Map<String, String> propertyMap) {
        return PropertyConverter.convertFromMap(propertyMap, DEFAULT_EQUALS, DEFAULT_SPLIT);
    }

    public static String convertFromMap(Map<String, String> propertyMap, String equalsTag, String splitTag) {
        if (propertyMap == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            sb.append(entry.getKey()).append(equalsTag).append(entry.getValue()).append(splitTag);
        }
        return sb.toString();
    }

    public static Map<String, String> convertToMap(String propertyString) {
        return PropertyConverter.convertToMap(propertyString, DEFAULT_EQUALS, DEFAULT_SPLIT);
    }

    public static Map<String, String> convertToMap(String propertyString, String equalsTag, String splitTag) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (StringUtil.isBlank(propertyString)) {
            return propertyMap;
        }
        String[] propertyArray = propertyString.split(splitTag);
        for (int i = 0; i < propertyArray.length; ++i) {
            String[] keyValue = propertyArray[i].split(equalsTag);
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            propertyMap.put(keyValue[0], keyValue[1]);
        }
        return propertyMap;
    }
}

