/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.biz.common.util;

import com.netfinworks.common.util.money.Money;
import java.io.Serializable;

public class QueryBase
implements Serializable {
    private static final long serialVersionUID = 8462451875633214573L;
    private static final Integer defaultPageSize = new Integer(20);
    private static final Integer defaultFriatPage = new Integer(1);
    private static final Integer defaultTotleItem = new Integer(0);
    private Integer totalItem;
    private Integer pageSize;
    private Integer currentPage;
    private Money totalSum = new Money(0L, 0);
    private int startRow;
    private int endRow;
    private boolean needQeryTotal = false;
    private boolean needDelete = false;
    private boolean needQueryAll = false;

    public Money getTotalSum() {
        return this.totalSum;
    }

    public void setTotalSum(long cent) {
        this.totalSum.setCent(cent);
    }

    public boolean isAllowedQuery() {
        throw new RuntimeException("Please implement it in sub classes.");
    }

    protected final Integer getDefaultPageSize() {
        return defaultPageSize;
    }

    public Integer getCurrentPage() {
        if (this.currentPage == null) {
            return defaultFriatPage;
        }
        return this.currentPage;
    }

    public void setCurrentPage(Integer cPage) {
        this.currentPage = cPage == null || cPage <= 0 ? defaultFriatPage : cPage;
    }

    public Integer getPageSize() {
        if (this.pageSize == null) {
            return this.getDefaultPageSize();
        }
        return this.pageSize;
    }

    public boolean hasSetPageSize() {
        return this.pageSize != null;
    }

    public void setPageSize(Integer pSize) {
        if (pSize == null) {
            throw new IllegalArgumentException("PageSize can't be null.");
        }
        if (pSize <= 0) {
            throw new IllegalArgumentException("PageSize must great than zero.");
        }
        this.pageSize = pSize;
    }

    public Integer getTotalItem() {
        if (this.totalItem == null) {
            return defaultTotleItem;
        }
        return this.totalItem;
    }

    public void setTotalItem(Integer tItem) {
        if (tItem == null) {
            tItem = new Integer(0);
        }
        this.totalItem = tItem;
    }

    public int getTotalPage() {
        int pgSize = this.getPageSize();
        int total = this.getTotalItem();
        int result = total / pgSize;
        if (total % pgSize != 0) {
            ++result;
        }
        return result;
    }

    public int getPageFristItem() {
        if (!this.needQeryTotal) {
            int cPage = this.getCurrentPage();
            if (cPage == 1) {
                return 1;
            }
            int pgSize = this.getPageSize();
            return pgSize * --cPage + 1;
        }
        return 0;
    }

    public int getPageLastItem() {
        if (!this.needQeryTotal) {
            int totalItem;
            int cPage = this.getCurrentPage();
            int pgSize = this.getPageSize();
            int assumeLast = pgSize * cPage;
            if (assumeLast > (totalItem = this.getTotalItem().intValue())) {
                return totalItem;
            }
            return assumeLast;
        }
        return this.getTotalItem();
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    protected String getSQLBlurValue(String value) {
        if (value == null) {
            return null;
        }
        return value + '%';
    }

    public boolean isNeedQeryTotal() {
        return this.needQeryTotal;
    }

    public void setNeedQeryTotal(boolean needQeryTotal) {
        this.needQeryTotal = needQeryTotal;
    }

    public boolean isNeedDelete() {
        return this.needDelete;
    }

    public void setNeedDelete(boolean needDelete) {
        this.needDelete = needDelete;
    }

    public boolean isNeedQueryAll() {
        return this.needQueryAll;
    }

    public void setNeedQueryAll(boolean needQueryAll) {
        this.needQueryAll = needQueryAll;
    }

    public <K extends QueryBase> void copyProperties(K k) {
        if (k == null) {
            return;
        }
        k.setCurrentPage(this.currentPage);
        k.setEndRow(this.endRow);
        k.setNeedDelete(this.needDelete);
        k.setNeedQeryTotal(this.needQeryTotal);
        k.setNeedQueryAll(this.needQueryAll);
        k.setStartRow(this.startRow);
        k.setTotalItem(this.totalItem);
        if (this.totalSum != null) {
            k.setTotalSum(this.totalSum.getCent());
        }
    }
}

