/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.lang;

import com.netfinworks.common.lang.StringUtil;
import com.netfinworks.common.lang.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class FileUtil {
    private static final char COLON_CHAR = ':';
    private static final String UNC_PREFIX = "//";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';
    private static final String ALL_SLASH = "/\\";
    public static final String SLASH = "/";
    public static final String EXTENSION_SEPARATOR = ".";
    public static final String CURRENT_DIR = ".";
    public static final String UP_LEVEL_DIR = "..";

    public static String normalizeAbsolutePath(String path) {
        Object normalizedPath = FileUtil.normalizePath(path, false);
        if (normalizedPath != null && !((String)normalizedPath).startsWith(SLASH)) {
            normalizedPath = ((String)normalizedPath).equals(".") || ((String)normalizedPath).equals("./") ? SLASH : (((String)normalizedPath).startsWith(UP_LEVEL_DIR) ? null : '/' + (String)normalizedPath);
        }
        return normalizedPath;
    }

    public static String normalizePath(String path) {
        return FileUtil.normalizePath(path, SystemUtil.getOsInfo().isWindows());
    }

    public static String normalizeWindowsPath(String path) {
        return FileUtil.normalizePath(path, true);
    }

    public static String normalizeUnixPath(String path) {
        return FileUtil.normalizePath(path, false);
    }

    private static String normalizePath(String path, boolean isWindows) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        String prefix = FileUtil.getSystemDependentPrefix(path = path.replace('\\', '/'), isWindows);
        if (prefix == null) {
            return null;
        }
        path = path.substring(prefix.length());
        if (prefix.length() > 0 || path.startsWith(SLASH)) {
            prefix = prefix + '/';
        }
        boolean endsWithSlash = path.endsWith(SLASH);
        StringTokenizer tokenizer = new StringTokenizer(path, SLASH);
        StringBuffer buffer = new StringBuffer(prefix.length() + path.length());
        int level = 0;
        buffer.append(prefix);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (".".equals(element)) continue;
            if (UP_LEVEL_DIR.equals(element)) {
                if (level == 0) {
                    if (prefix.length() > 0) {
                        return null;
                    }
                    buffer.append(UP_LEVEL_DIR).append('/');
                    continue;
                }
                --level;
                boolean found = false;
                for (int i = buffer.length() - 2; i >= prefix.length(); --i) {
                    if (buffer.charAt(i) != '/') continue;
                    buffer.setLength(i + 1);
                    found = true;
                    break;
                }
                if (found) continue;
                buffer.setLength(prefix.length());
                continue;
            }
            buffer.append(element).append('/');
            ++level;
        }
        if (buffer.length() == 0) {
            buffer.append(".").append('/');
        }
        if (!endsWithSlash && buffer.length() > prefix.length() && buffer.charAt(buffer.length() - 1) == '/') {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static String getSystemDependentPrefix(String path, boolean isWindows) {
        if (isWindows) {
            if (path.startsWith(UNC_PREFIX)) {
                if (path.length() == UNC_PREFIX.length()) {
                    return null;
                }
                int index = path.indexOf(SLASH, UNC_PREFIX.length());
                if (index != -1) {
                    return path.substring(0, index);
                }
                return path;
            }
            if (path.length() > 1 && path.charAt(1) == ':') {
                return path.substring(0, 2).toUpperCase();
            }
        }
        return "";
    }

    public static String getPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, SystemUtil.getOsInfo().isWindows());
    }

    public static String getWindowsPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, true);
    }

    public static String getUnixPathBasedOn(String basedir, String path) {
        return FileUtil.getPathBasedOn(basedir, path, false);
    }

    private static String getPathBasedOn(String basedir, String path, boolean isWindows) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        String prefix = FileUtil.getSystemDependentPrefix(path = path.replace('\\', '/'), isWindows);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0 || path.length() > prefix.length() && path.charAt(prefix.length()) == '/') {
            return FileUtil.normalizePath(path, isWindows);
        }
        if (basedir == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(basedir.trim());
        if (basedir.length() > 0 && path.length() > 0 && basedir.charAt(basedir.length() - 1) != '/') {
            buffer.append('/');
        }
        buffer.append(path);
        return FileUtil.normalizePath(buffer.toString(), isWindows);
    }

    public static String getRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, SystemUtil.getOsInfo().isWindows());
    }

    public static String getWindowsRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, true);
    }

    public static String getUnixRelativePath(String basedir, String path) {
        return FileUtil.getRelativePath(basedir, path, false);
    }

    private static String getRelativePath(String basedir, String path, boolean isWindows) {
        int i;
        if ((basedir = FileUtil.normalizePath(basedir, isWindows)) == null) {
            return null;
        }
        String basePrefix = FileUtil.getSystemDependentPrefix(basedir, isWindows);
        if (basePrefix == null || basePrefix.length() == 0 && !basedir.startsWith(SLASH)) {
            return null;
        }
        if ((path = FileUtil.getPathBasedOn(basedir, path, isWindows)) == null) {
            return null;
        }
        String prefix = FileUtil.getSystemDependentPrefix(path, isWindows);
        if (!basePrefix.equals(prefix)) {
            return path;
        }
        boolean endsWithSlash = path.endsWith(SLASH);
        String[] baseParts = StringUtil.split(basedir.substring(basePrefix.length()), '/');
        String[] parts = StringUtil.split(path.substring(prefix.length()), '/');
        StringBuffer buffer = new StringBuffer();
        if (isWindows) {
            for (i = 0; i < baseParts.length && i < parts.length && baseParts[i].equalsIgnoreCase(parts[i]); ++i) {
            }
        } else {
            while (i < baseParts.length && i < parts.length && baseParts[i].equals(parts[i])) {
                ++i;
            }
        }
        if (i < baseParts.length && i < parts.length) {
            for (int j = i; j < baseParts.length; ++j) {
                buffer.append(UP_LEVEL_DIR).append('/');
            }
        }
        while (i < parts.length) {
            buffer.append(parts[i]);
            if (i < parts.length - 1) {
                buffer.append('/');
            }
            ++i;
        }
        if (buffer.length() == 0) {
            buffer.append(".");
        }
        String relpath = buffer.toString();
        if (endsWithSlash && !relpath.endsWith(SLASH)) {
            relpath = relpath + SLASH;
        }
        return relpath;
    }

    public static File toFile(URL url) {
        String path;
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file") && (path = url.getPath()) != null) {
            return new File(path);
        }
        return null;
    }

    public static String[] parseExtension(String path) {
        path = StringUtil.trimToEmpty(path);
        String[] parts = new String[]{path, null};
        if (StringUtil.isEmpty(path)) {
            return parts;
        }
        int index = StringUtil.lastIndexOf(path, ".");
        String extension = null;
        if (index >= 0 && !StringUtil.containsNone(extension = StringUtil.trimToNull(StringUtil.substring(path, index + 1)), ALL_SLASH)) {
            extension = null;
            index = -1;
        }
        if (index >= 0) {
            parts[0] = StringUtil.substring(path, 0, index);
        }
        parts[1] = extension;
        return parts;
    }

    public static InputStream getInputstream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static boolean isExcelFileType(String fileNameTemplate) {
        return fileNameTemplate.toLowerCase().contains(".xls");
    }

    public static String getFileExt(String fileName) {
        String ext = "";
        if (StringUtil.isBlank(fileName)) {
            return ext;
        }
        int dotPos = fileName.lastIndexOf(".");
        if (fileName.lastIndexOf(".") >= 0) {
            ext = fileName.substring(dotPos + 1);
        }
        return ext;
    }

    public static String getFileNameNoExt(String fileName) {
        String noext = null;
        if (StringUtil.isBlank(fileName)) {
            return noext;
        }
        int dotPos = fileName.lastIndexOf(".");
        noext = dotPos >= 0 ? fileName.substring(0, dotPos) : fileName;
        return noext;
    }

    public static String getFileName(String filePath) {
        String fileName = null;
        if (StringUtil.isBlank(filePath)) {
            return fileName;
        }
        int dotPos = (filePath = FileUtil.normalizePath(filePath)).lastIndexOf(SLASH);
        fileName = dotPos >= 0 ? filePath.substring(dotPos + 1, filePath.length()) : filePath;
        return fileName;
    }

    public static boolean move(String sourceFile, String destDirection) {
        File oldFile = new File(sourceFile);
        File newDir = new File(destDirection);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        File newFile = new File(destDirection + SLASH + FileUtil.getFileName(sourceFile));
        boolean success = oldFile.renameTo(newFile);
        oldFile.delete();
        return success;
    }

    public static boolean move(String sourceFile, String destDirection, String newfilename) {
        File oldFile = new File(sourceFile);
        File newDir = new File(destDirection);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        File newFile = new File(destDirection + SLASH + newfilename);
        boolean success = oldFile.renameTo(newFile);
        oldFile.delete();
        return success;
    }
}

