/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.lang;

import com.netfinworks.common.lang.StringUtil;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SystemUtil {
    private static final JvmSpecInfo JVM_SPEC_INFO = new JvmSpecInfo();
    private static final JvmInfo JVM_INFO = new JvmInfo();
    private static final JavaSpecInfo JAVA_SPEC_INFO = new JavaSpecInfo();
    private static final JavaInfo JAVA_INFO = new JavaInfo();
    private static final OsInfo OS_INFO = new OsInfo();
    private static final UserInfo USER_INFO = new UserInfo();
    private static final HostInfo HOST_INFO = new HostInfo();
    private static final JavaRuntimeInfo JAVA_RUNTIME_INFO = new JavaRuntimeInfo();

    public static final JvmSpecInfo getJvmSpecInfo() {
        return JVM_SPEC_INFO;
    }

    public static final JvmInfo getJvmInfo() {
        return JVM_INFO;
    }

    public static final JavaSpecInfo getJavaSpecInfo() {
        return JAVA_SPEC_INFO;
    }

    public static final JavaInfo getJavaInfo() {
        return JAVA_INFO;
    }

    public static final JavaRuntimeInfo getJavaRuntimeInfo() {
        return JAVA_RUNTIME_INFO;
    }

    public static final OsInfo getOsInfo() {
        return OS_INFO;
    }

    public static final UserInfo getUserInfo() {
        return USER_INFO;
    }

    public static final HostInfo getHostInfo() {
        return HOST_INFO;
    }

    public static final void dumpSystemInfo() {
        SystemUtil.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static final void dumpSystemInfo(PrintWriter out) {
        out.println("--------------");
        out.println(SystemUtil.getJvmSpecInfo());
        out.println("--------------");
        out.println(SystemUtil.getJvmInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaSpecInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaInfo());
        out.println("--------------");
        out.println(SystemUtil.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(SystemUtil.getOsInfo());
        out.println("--------------");
        out.println(SystemUtil.getUserInfo());
        out.println("--------------");
        out.println(SystemUtil.getHostInfo());
        out.println("--------------");
        out.flush();
    }

    private static String getSystemProperty(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            if (!quiet) {
                System.err.println("Caught a SecurityException reading the system property '" + name + "'; the SystemUtil property value will default to null.");
            }
            return null;
        }
    }

    private static void append(StringBuffer buffer, String caption, String value) {
        buffer.append(caption).append(StringUtil.defaultIfNull(value, "[n/a]")).append("\n");
    }

    public static final class HostInfo {
        private final String HOST_NAME;
        private final String HOST_ADDRESS;

        private HostInfo() {
            String hostAddress;
            String hostName;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
                hostAddress = localhost.getHostAddress();
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
                hostAddress = "127.0.0.1";
            }
            this.HOST_NAME = hostName;
            this.HOST_ADDRESS = hostAddress;
        }

        public final String getName() {
            return this.HOST_NAME;
        }

        public final String getAddress() {
            return this.HOST_ADDRESS;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "Host Name:    ", this.getName());
            SystemUtil.append(buffer, "Host Address: ", this.getAddress());
            return buffer.toString();
        }
    }

    public static final class UserInfo {
        private final String USER_NAME = SystemUtil.access$800("user.name", false);
        private final String USER_HOME = SystemUtil.access$800("user.home", false);
        private final String USER_DIR = SystemUtil.access$800("user.dir", false);
        private final String USER_LANGUAGE = SystemUtil.access$800("user.language", false);
        private final String USER_COUNTRY = SystemUtil.access$800("user.country", false) == null ? SystemUtil.access$800("user.region", false) : SystemUtil.access$800("user.country", false);
        private final String JAVA_IO_TMPDIR = SystemUtil.access$800("java.io.tmpdir", false);

        private UserInfo() {
        }

        public final String getName() {
            return this.USER_NAME;
        }

        public final String getHomeDir() {
            return this.USER_HOME;
        }

        public final String getCurrentDir() {
            return this.USER_DIR;
        }

        public final String getTempDir() {
            return this.JAVA_IO_TMPDIR;
        }

        public final String getLanguage() {
            return this.USER_LANGUAGE;
        }

        public final String getCountry() {
            return this.USER_COUNTRY;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "User Name:        ", this.getName());
            SystemUtil.append(buffer, "User Home Dir:    ", this.getHomeDir());
            SystemUtil.append(buffer, "User Current Dir: ", this.getCurrentDir());
            SystemUtil.append(buffer, "User Temp Dir:    ", this.getTempDir());
            SystemUtil.append(buffer, "User Language:    ", this.getLanguage());
            SystemUtil.append(buffer, "User Country:     ", this.getCountry());
            return buffer.toString();
        }
    }

    public static final class OsInfo {
        private final String OS_VERSION = SystemUtil.access$800("os.version", false);
        private final String OS_ARCH = SystemUtil.access$800("os.arch", false);
        private final String OS_NAME = SystemUtil.access$800("os.name", false);
        private final boolean IS_OS_AIX = this.getOSMatches("AIX");
        private final boolean IS_OS_HP_UX = this.getOSMatches("HP-UX");
        private final boolean IS_OS_IRIX = this.getOSMatches("Irix");
        private final boolean IS_OS_LINUX = this.getOSMatches("Linux") || this.getOSMatches("LINUX");
        private final boolean IS_OS_MAC = this.getOSMatches("Mac");
        private final boolean IS_OS_MAC_OSX = this.getOSMatches("Mac OS X");
        private final boolean IS_OS_OS2 = this.getOSMatches("OS/2");
        private final boolean IS_OS_SOLARIS = this.getOSMatches("Solaris");
        private final boolean IS_OS_SUN_OS = this.getOSMatches("SunOS");
        private final boolean IS_OS_WINDOWS = this.getOSMatches("Windows");
        private final boolean IS_OS_WINDOWS_2000 = this.getOSMatches("Windows", "5.0");
        private final boolean IS_OS_WINDOWS_95 = this.getOSMatches("Windows 9", "4.0");
        private final boolean IS_OS_WINDOWS_98 = this.getOSMatches("Windows 9", "4.1");
        private final boolean IS_OS_WINDOWS_ME = this.getOSMatches("Windows", "4.9");
        private final boolean IS_OS_WINDOWS_NT = this.getOSMatches("Windows NT");
        private final boolean IS_OS_WINDOWS_XP = this.getOSMatches("Windows", "5.1");
        private final String FILE_SEPARATOR = SystemUtil.access$800("file.separator", false);
        private final String LINE_SEPARATOR = SystemUtil.access$800("line.separator", false);
        private final String PATH_SEPARATOR = SystemUtil.access$800("path.separator", false);

        private OsInfo() {
        }

        public final String getArch() {
            return this.OS_ARCH;
        }

        public final String getName() {
            return this.OS_NAME;
        }

        public final String getVersion() {
            return this.OS_VERSION;
        }

        public final boolean isAix() {
            return this.IS_OS_AIX;
        }

        public final boolean isHpUx() {
            return this.IS_OS_HP_UX;
        }

        public final boolean isIrix() {
            return this.IS_OS_IRIX;
        }

        public final boolean isLinux() {
            return this.IS_OS_LINUX;
        }

        public final boolean isMac() {
            return this.IS_OS_MAC;
        }

        public final boolean isMacOsX() {
            return this.IS_OS_MAC_OSX;
        }

        public final boolean isOs2() {
            return this.IS_OS_OS2;
        }

        public final boolean isSolaris() {
            return this.IS_OS_SOLARIS;
        }

        public final boolean isSunOS() {
            return this.IS_OS_SUN_OS;
        }

        public final boolean isWindows() {
            return this.IS_OS_WINDOWS;
        }

        public final boolean isWindows2000() {
            return this.IS_OS_WINDOWS_2000;
        }

        public final boolean isWindows95() {
            return this.IS_OS_WINDOWS_95;
        }

        public final boolean isWindows98() {
            return this.IS_OS_WINDOWS_98;
        }

        public final boolean isWindowsME() {
            return this.IS_OS_WINDOWS_ME;
        }

        public final boolean isWindowsNT() {
            return this.IS_OS_WINDOWS_NT;
        }

        public final boolean isWindowsXP() {
            return this.IS_OS_WINDOWS_XP;
        }

        private final boolean getOSMatches(String osNamePrefix) {
            if (this.OS_NAME == null) {
                return false;
            }
            return this.OS_NAME.startsWith(osNamePrefix);
        }

        private final boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
            if (this.OS_NAME == null || this.OS_VERSION == null) {
                return false;
            }
            return this.OS_NAME.startsWith(osNamePrefix) && this.OS_VERSION.startsWith(osVersionPrefix);
        }

        public final String getFileEncoding() {
            return "UTF-8";
        }

        public final String getFileSeparator() {
            return this.FILE_SEPARATOR;
        }

        public final String getLineSeparator() {
            return this.LINE_SEPARATOR;
        }

        public final String getPathSeparator() {
            return this.PATH_SEPARATOR;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "OS Arch:        ", this.getArch());
            SystemUtil.append(buffer, "OS Name:        ", this.getName());
            SystemUtil.append(buffer, "OS Version:     ", this.getVersion());
            SystemUtil.append(buffer, "File Encoding:  ", this.getFileEncoding());
            SystemUtil.append(buffer, "File Separator: ", this.getFileSeparator());
            SystemUtil.append(buffer, "Line Separator: ", this.getLineSeparator());
            SystemUtil.append(buffer, "Path Separator: ", this.getPathSeparator());
            return buffer.toString();
        }
    }

    public static final class JavaRuntimeInfo {
        private final String JAVA_RUNTIME_NAME = SystemUtil.access$800("java.runtime.name", false);
        private final String JAVA_RUNTIME_VERSION = SystemUtil.access$800("java.runtime.version", false);
        private final String JAVA_HOME = SystemUtil.access$800("java.home", false);
        private final String JAVA_EXT_DIRS = SystemUtil.access$800("java.ext.dirs", false);
        private final String JAVA_ENDORSED_DIRS = SystemUtil.access$800("java.endorsed.dirs", false);
        private final String JAVA_CLASS_PATH = SystemUtil.access$800("java.class.path", false);
        private final String JAVA_CLASS_VERSION = SystemUtil.access$800("java.class.version", false);
        private final String JAVA_LIBRARY_PATH = SystemUtil.access$800("java.library.path", false);

        private JavaRuntimeInfo() {
        }

        public final String getName() {
            return this.JAVA_RUNTIME_NAME;
        }

        public final String getVersion() {
            return this.JAVA_RUNTIME_VERSION;
        }

        public final String getHomeDir() {
            return this.JAVA_HOME;
        }

        public final String getExtDirs() {
            return this.JAVA_EXT_DIRS;
        }

        public final String getEndorsedDirs() {
            return this.JAVA_ENDORSED_DIRS;
        }

        public final String getClassPath() {
            return this.JAVA_CLASS_PATH;
        }

        public final String[] getClassPathArray() {
            return StringUtil.split(this.getClassPath(), SystemUtil.getOsInfo().getPathSeparator());
        }

        public final String getClassVersion() {
            return this.JAVA_CLASS_VERSION;
        }

        public final String getLibraryPath() {
            return this.JAVA_LIBRARY_PATH;
        }

        public final String[] getLibraryPathArray() {
            return StringUtil.split(this.getLibraryPath(), SystemUtil.getOsInfo().getPathSeparator());
        }

        public final String getProtocolPackages() {
            return SystemUtil.getSystemProperty("java.protocol.handler.pkgs", true);
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "Java Runtime Name:      ", this.getName());
            SystemUtil.append(buffer, "Java Runtime Version:   ", this.getVersion());
            SystemUtil.append(buffer, "Java Home Dir:          ", this.getHomeDir());
            SystemUtil.append(buffer, "Java Extension Dirs:    ", this.getExtDirs());
            SystemUtil.append(buffer, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
            SystemUtil.append(buffer, "Java Class Path:        ", this.getClassPath());
            SystemUtil.append(buffer, "Java Class Version:     ", this.getClassVersion());
            SystemUtil.append(buffer, "Java Library Path:      ", this.getLibraryPath());
            SystemUtil.append(buffer, "Java Protocol Packages: ", this.getProtocolPackages());
            return buffer.toString();
        }
    }

    public static final class JavaInfo {
        private final String JAVA_VERSION = SystemUtil.access$800("java.version", false);
        private final float JAVA_VERSION_FLOAT = this.getJavaVersionAsFloat();
        private final int JAVA_VERSION_INT = this.getJavaVersionAsInt();
        private final String JAVA_VENDOR = SystemUtil.access$800("java.vendor", false);
        private final String JAVA_VENDOR_URL = SystemUtil.access$800("java.vendor.url", false);
        private final boolean IS_JAVA_1_1 = this.getJavaVersionMatches("1.1");
        private final boolean IS_JAVA_1_2 = this.getJavaVersionMatches("1.2");
        private final boolean IS_JAVA_1_3 = this.getJavaVersionMatches("1.3");
        private final boolean IS_JAVA_1_4 = this.getJavaVersionMatches("1.4");
        private final boolean IS_JAVA_1_5 = this.getJavaVersionMatches("1.5");

        private JavaInfo() {
        }

        public final String getVersion() {
            return this.JAVA_VERSION;
        }

        public final float getVersionFloat() {
            return this.JAVA_VERSION_FLOAT;
        }

        public final int getVersionInt() {
            return this.JAVA_VERSION_INT;
        }

        private final float getJavaVersionAsFloat() {
            if (this.JAVA_VERSION == null) {
                return 0.0f;
            }
            String str = this.JAVA_VERSION.substring(0, 3);
            if (this.JAVA_VERSION.length() >= 5) {
                str = str + this.JAVA_VERSION.substring(4, 5);
            }
            return Float.parseFloat(str);
        }

        private final int getJavaVersionAsInt() {
            if (this.JAVA_VERSION == null) {
                return 0;
            }
            String str = this.JAVA_VERSION.substring(0, 1);
            str = str + this.JAVA_VERSION.substring(2, 3);
            str = this.JAVA_VERSION.length() >= 5 ? str + this.JAVA_VERSION.substring(4, 5) : str + "0";
            return Integer.parseInt(str);
        }

        public final String getVendor() {
            return this.JAVA_VENDOR;
        }

        public final String getVendorURL() {
            return this.JAVA_VENDOR_URL;
        }

        public final boolean isJava11() {
            return this.IS_JAVA_1_1;
        }

        public final boolean isJava12() {
            return this.IS_JAVA_1_2;
        }

        public final boolean isJava13() {
            return this.IS_JAVA_1_3;
        }

        public final boolean isJava14() {
            return this.IS_JAVA_1_4;
        }

        public final boolean isJava15() {
            return this.IS_JAVA_1_5;
        }

        private final boolean getJavaVersionMatches(String versionPrefix) {
            if (this.JAVA_VERSION == null) {
                return false;
            }
            return this.JAVA_VERSION.startsWith(versionPrefix);
        }

        public final boolean isJavaVersionAtLeast(float requiredVersion) {
            return this.getVersionFloat() >= requiredVersion;
        }

        public final boolean isJavaVersionAtLeast(int requiredVersion) {
            return this.getVersionInt() >= requiredVersion;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "Java Version:    ", this.getVersion());
            SystemUtil.append(buffer, "Java Vendor:     ", this.getVendor());
            SystemUtil.append(buffer, "Java Vendor URL: ", this.getVendorURL());
            return buffer.toString();
        }
    }

    public static final class JavaSpecInfo {
        private final String JAVA_SPECIFICATION_NAME = SystemUtil.access$800("java.specification.name", false);
        private final String JAVA_SPECIFICATION_VERSION = SystemUtil.access$800("java.specification.version", false);
        private final String JAVA_SPECIFICATION_VENDOR = SystemUtil.access$800("java.specification.vendor", false);

        private JavaSpecInfo() {
        }

        public final String getName() {
            return this.JAVA_SPECIFICATION_NAME;
        }

        public final String getVersion() {
            return this.JAVA_SPECIFICATION_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_SPECIFICATION_VENDOR;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "Java Spec. Name:    ", this.getName());
            SystemUtil.append(buffer, "Java Spec. Version: ", this.getVersion());
            SystemUtil.append(buffer, "Java Spec. Vendor:  ", this.getVendor());
            return buffer.toString();
        }
    }

    public static final class JvmInfo {
        private final String JAVA_VM_NAME = SystemUtil.access$800("java.vm.name", false);
        private final String JAVA_VM_VERSION = SystemUtil.access$800("java.vm.version", false);
        private final String JAVA_VM_VENDOR = SystemUtil.access$800("java.vm.vendor", false);
        private final String JAVA_VM_INFO = SystemUtil.access$800("java.vm.info", false);

        private JvmInfo() {
        }

        public final String getName() {
            return this.JAVA_VM_NAME;
        }

        public final String getVersion() {
            return this.JAVA_VM_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_VM_VENDOR;
        }

        public final String getInfo() {
            return this.JAVA_VM_INFO;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "JavaVM Name:    ", this.getName());
            SystemUtil.append(buffer, "JavaVM Version: ", this.getVersion());
            SystemUtil.append(buffer, "JavaVM Vendor:  ", this.getVendor());
            SystemUtil.append(buffer, "JavaVM Info:    ", this.getInfo());
            return buffer.toString();
        }
    }

    public static final class JvmSpecInfo {
        private final String JAVA_VM_SPECIFICATION_NAME = SystemUtil.access$800("java.vm.specification.name", false);
        private final String JAVA_VM_SPECIFICATION_VERSION = SystemUtil.access$800("java.vm.specification.version", false);
        private final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtil.access$800("java.vm.specification.vendor", false);

        private JvmSpecInfo() {
        }

        public final String getName() {
            return this.JAVA_VM_SPECIFICATION_NAME;
        }

        public final String getVersion() {
            return this.JAVA_VM_SPECIFICATION_VERSION;
        }

        public final String getVendor() {
            return this.JAVA_VM_SPECIFICATION_VENDOR;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer();
            SystemUtil.append(buffer, "JavaVM Spec. Name:    ", this.getName());
            SystemUtil.append(buffer, "JavaVM Spec. Version: ", this.getVersion());
            SystemUtil.append(buffer, "JavaVM Spec. Vendor:  ", this.getVendor());
            return buffer.toString();
        }
    }
}

