/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.util;

import com.netfinworks.common.lang.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final long ONE_DAY_SECONDS = 86400L;
    public static final String shortFormat = "yyyyMMdd";
    public static final String longFormat = "yyyyMMddHHmmss";
    public static final String webFormat = "yyyy-MM-dd";
    public static final String timeFormat = "HHmmss";
    public static final String monthFormat = "yyyyMM";
    public static final String chineseDtFormat = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String newFormat = "yyyy-MM-dd HH:mm:ss";
    public static final String noSecondFormat = "yyyy-MM-dd HH:mm";
    public static final long ONE_DAY_MILL_SECONDS = 86400000L;

    public static DateFormat getNewDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(false);
        return df;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date parseDateNoTime(String sDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(shortFormat);
        if (sDate == null || sDate.length() < shortFormat.length()) {
            throw new ParseException("length too little", 0);
        }
        if (!StringUtil.isNumeric(sDate)) {
            throw new ParseException("not all digit", 0);
        }
        return dateFormat.parse(sDate);
    }

    public static Date parseDateNoTime(String sDate, String format) throws ParseException {
        if (StringUtil.isBlank(format)) {
            throw new ParseException("Null format. ", 0);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (sDate == null || sDate.length() < format.length()) {
            throw new ParseException("length too little", 0);
        }
        return dateFormat.parse(sDate);
    }

    public static Date parseDateNoTimeWithDelimit(String sDate, String delimit) throws ParseException {
        sDate = sDate.replaceAll(delimit, "");
        SimpleDateFormat dateFormat = new SimpleDateFormat(shortFormat);
        if (sDate == null || sDate.length() != shortFormat.length()) {
            throw new ParseException("length not match", 0);
        }
        return dateFormat.parse(sDate);
    }

    public static Date parseDateLongFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat);
        Date d = null;
        if (sDate != null && sDate.length() == longFormat.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date parseDateNewFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(newFormat);
        Date d = null;
        if (sDate != null && sDate.length() == newFormat.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date addHours(Date date, long hours) {
        return DateUtil.addMinutes(date, hours * 60L);
    }

    public static Date addMinutes(Date date, long minutes) {
        return DateUtil.addSeconds(date, minutes * 60L);
    }

    public static Date addSeconds(Date date1, long secs) {
        return new Date(date1.getTime() + secs * 1000L);
    }

    public static boolean isValidHour(String hourStr) {
        int hour;
        return !StringUtil.isEmpty(hourStr) && StringUtil.isNumeric(hourStr) && (hour = new Integer(hourStr).intValue()) >= 0 && hour <= 23;
    }

    public static boolean isValidMinuteOrSecond(String str) {
        int hour;
        return !StringUtil.isEmpty(str) && StringUtil.isNumeric(str) && (hour = new Integer(str).intValue()) >= 0 && hour <= 59;
    }

    public static Date addDays(Date date1, long days) {
        return DateUtil.addSeconds(date1, days * 86400L);
    }

    public static String getTomorrowDateString(String sDate) throws ParseException {
        Date aDate = DateUtil.parseDateNoTime(sDate);
        aDate = DateUtil.addSeconds(aDate, 86400L);
        return DateUtil.getDateString(aDate);
    }

    public static String getTomorrowWebDate(String sDate) throws ParseException {
        String tomorrowShortDate = DateUtil.getTomorrowDateString(DateUtil.convertWeb2ShortFormat(sDate));
        return DateUtil.convert2WebFormat(tomorrowShortDate);
    }

    public static String getLongDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getNewFormatDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(newFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getDateString(Date date, DateFormat dateFormat) {
        if (date == null || dateFormat == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static String getYesterDayDateString(String sDate) throws ParseException {
        Date aDate = DateUtil.parseDateNoTime(sDate);
        aDate = DateUtil.addSeconds(aDate, -86400L);
        return DateUtil.getDateString(aDate);
    }

    public static String getDateString(Date date) {
        DateFormat df = DateUtil.getNewDateFormat(shortFormat);
        return df.format(date);
    }

    public static String getWebDateString(Date date) {
        DateFormat dateFormat = DateUtil.getNewDateFormat(webFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getNoSecondDateString(Date date) {
        DateFormat dateFormat = DateUtil.getNewDateFormat(noSecondFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getChineseDateString(Date date) {
        DateFormat dateFormat = DateUtil.getNewDateFormat(chineseDtFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getTodayString() {
        DateFormat dateFormat = DateUtil.getNewDateFormat(shortFormat);
        return DateUtil.getDateString(new Date(), dateFormat);
    }

    public static String getTimeString(Date date) {
        DateFormat dateFormat = DateUtil.getNewDateFormat(timeFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static String getBeforeDayString(int days) {
        Date date = new Date(System.currentTimeMillis() - 86400000L * (long)days);
        DateFormat dateFormat = DateUtil.getNewDateFormat(shortFormat);
        return DateUtil.getDateString(date, dateFormat);
    }

    public static long getDiffSeconds(Date one, Date two) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(one);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(two);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 1000L;
    }

    public static long getDiffMinutes(Date one, Date two) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(one);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(two);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 60000L;
    }

    public static long getDiffDays(Date one, Date two) {
        GregorianCalendar sysDate = new GregorianCalendar();
        sysDate.setTime(one);
        GregorianCalendar failDate = new GregorianCalendar();
        failDate.setTime(two);
        return (sysDate.getTimeInMillis() - failDate.getTimeInMillis()) / 86400000L;
    }

    public static String getBeforeDayString(String dateString, int days) {
        Date date;
        DateFormat df = DateUtil.getNewDateFormat(shortFormat);
        try {
            date = df.parse(dateString);
        }
        catch (ParseException e) {
            date = new Date();
        }
        date = new Date(date.getTime() - 86400000L * (long)days);
        return df.format(date);
    }

    public static boolean isValidShortDateFormat(String strDate) {
        if (strDate.length() != shortFormat.length()) {
            return false;
        }
        try {
            Integer.parseInt(strDate);
        }
        catch (Exception NumberFormatException) {
            return false;
        }
        DateFormat df = DateUtil.getNewDateFormat(shortFormat);
        try {
            df.parse(strDate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidShortDateFormat(String strDate, String delimiter) {
        String temp = strDate.replaceAll(delimiter, "");
        return DateUtil.isValidShortDateFormat(temp);
    }

    public static boolean isValidLongDateFormat(String strDate) {
        if (strDate.length() != longFormat.length()) {
            return false;
        }
        try {
            Long.parseLong(strDate);
        }
        catch (Exception NumberFormatException) {
            return false;
        }
        DateFormat df = DateUtil.getNewDateFormat(longFormat);
        try {
            df.parse(strDate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidLongDateFormat(String strDate, String delimiter) {
        String temp = strDate.replaceAll(delimiter, "");
        return DateUtil.isValidLongDateFormat(temp);
    }

    public static String getShortDateString(String strDate) {
        return DateUtil.getShortDateString(strDate, "-|/");
    }

    public static String getShortDateString(String strDate, String delimiter) {
        if (StringUtil.isBlank(strDate)) {
            return null;
        }
        String temp = strDate.replaceAll(delimiter, "");
        if (DateUtil.isValidShortDateFormat(temp)) {
            return temp;
        }
        return null;
    }

    public static String getShortFirstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        Date dt = new Date();
        cal.setTime(dt);
        cal.set(5, 1);
        DateFormat df = DateUtil.getNewDateFormat(shortFormat);
        return df.format(cal.getTime());
    }

    public static String getWebTodayString() {
        DateFormat df = DateUtil.getNewDateFormat(webFormat);
        return df.format(new Date());
    }

    public static String getWebFirstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        Date dt = new Date();
        cal.setTime(dt);
        cal.set(5, 1);
        DateFormat df = DateUtil.getNewDateFormat(webFormat);
        return df.format(cal.getTime());
    }

    public static String convert(String dateString, DateFormat formatIn, DateFormat formatOut) {
        try {
            Date date = formatIn.parse(dateString);
            return formatOut.format(date);
        }
        catch (ParseException e) {
            log.warn("convert() --- orign date error: " + dateString);
            return "";
        }
    }

    public static String convertWeb2ShortFormat(String dateString) {
        DateFormat df1 = DateUtil.getNewDateFormat(webFormat);
        DateFormat df2 = DateUtil.getNewDateFormat(shortFormat);
        return DateUtil.convert(dateString, df1, df2);
    }

    public static String convert2WebFormat(String dateString) {
        dateString = StringUtil.defaultIfNull(dateString);
        DateFormat df1 = DateUtil.getNewDateFormat(shortFormat);
        DateFormat df2 = DateUtil.getNewDateFormat(webFormat);
        return DateUtil.convert(dateString, df1, df2);
    }

    public static String convert2ChineseDtFormat(String dateString) {
        DateFormat df1 = DateUtil.getNewDateFormat(shortFormat);
        DateFormat df2 = DateUtil.getNewDateFormat(chineseDtFormat);
        return DateUtil.convert(dateString, df1, df2);
    }

    public static String convertFromWebFormat(String dateString) {
        DateFormat df1 = DateUtil.getNewDateFormat(shortFormat);
        DateFormat df2 = DateUtil.getNewDateFormat(webFormat);
        return DateUtil.convert(dateString, df2, df1);
    }

    public static boolean webDateNotLessThan(String date1, String date2) {
        DateFormat df = DateUtil.getNewDateFormat(webFormat);
        return DateUtil.dateNotLessThan(date1, date2, df);
    }

    public static boolean dateNotLessThan(String date1, String date2, DateFormat format) {
        try {
            Date d1 = format.parse(date1);
            Date d2 = format.parse(date2);
            return !d1.before(d2);
        }
        catch (ParseException e) {
            log.debug("dateNotLessThan() --- ParseException(" + date1 + ", " + date2 + ")");
            return false;
        }
    }

    public static String getEmailDate(Date today) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss");
        String todayStr = sdf.format(today);
        return todayStr;
    }

    public static String getSmsDate(Date today) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM\u6708dd\u65e5HH:mm");
        String todayStr = sdf.format(today);
        return todayStr;
    }

    public static String formatTimeRange(Date startDate, Date endDate, String format) {
        if (endDate == null || startDate == null) {
            return null;
        }
        String rt = null;
        long range = endDate.getTime() - startDate.getTime();
        long day = range / 86400000L;
        long hour = range % 86400000L / 3600000L;
        long minute = range % 3600000L / 60000L;
        if (range < 0L) {
            day = 0L;
            hour = 0L;
            minute = 0L;
        }
        rt = format.replaceAll("dd", String.valueOf(day));
        rt = rt.replaceAll("hh", String.valueOf(hour));
        rt = rt.replaceAll("mm", String.valueOf(minute));
        return rt;
    }

    public static String formatMonth(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(monthFormat).format(date);
    }

    public static Date getBeforeDate() {
        Date date = new Date();
        return new Date(date.getTime() - 86400000L);
    }

    public static Date getDayBegin(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(shortFormat);
        df.setLenient(false);
        String dateString = df.format(date);
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static boolean dateLessThanNowAddMin(Date date, long min) {
        return DateUtil.addMinutes(date, min).before(new Date());
    }

    public static boolean isBeforeNow(Date date) {
        if (date == null) {
            return false;
        }
        return date.compareTo(new Date()) < 0;
    }

    public static boolean isValidate(Date requestTime, Date effectTime, Date expiredTime) {
        if (requestTime == null || effectTime == null || expiredTime == null) {
            return false;
        }
        return effectTime.compareTo(requestTime) <= 0 && expiredTime.compareTo(requestTime) >= 0;
    }

    public static void main(String[] args) {
        System.out.println("[" + DateUtil.convert2WebFormat(null) + "]");
    }

    public static Date parseNoSecondFormat(String sDate) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(noSecondFormat);
        if (sDate == null || sDate.length() < noSecondFormat.length()) {
            throw new ParseException("length too little", 0);
        }
        if (!StringUtil.isNumeric(sDate)) {
            throw new ParseException("not all digit", 0);
        }
        return dateFormat.parse(sDate);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        SimpleDateFormat sdf = new SimpleDateFormat(webFormat);
        return sdf.format(date1).equals(sdf.format(date2));
    }

    public static Date getCurrentTS() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        return date;
    }

    public static Date getWeekBefore() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        return date;
    }

    public static Date getDateNearCurrent(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        Date date = calendar.getTime();
        return date;
    }
}

