/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Builder {
    static Logger logger = LoggerFactory.getLogger(MD5Builder.class);
    static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        FileInputStream fis = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (logger.isDebugEnabled()) {
                logger.debug("MD5\u6458\u8981\u957f\u5ea6\uff1a" + md.getDigestLength());
            }
            fis = new FileInputStream(file);
            byte[] buffer = new byte[2048];
            int length = -1;
            long s = System.currentTimeMillis();
            while ((length = fis.read(buffer)) != -1) {
                md.update(buffer, 0, length);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u6458\u8981\u751f\u6210\u6210\u529f,\u603b\u7528\u65f6: " + (System.currentTimeMillis() - s) + "ms");
            }
            byte[] b = md.digest();
            String string = MD5Builder.byteToHexString(b);
            return string;
        }
        catch (Exception ex) {
            logger.error("\u5f02\u5e38", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getMD5(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = md.digest(message.getBytes("UTF-8"));
            return MD5Builder.byteToHexString(b);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }
}

