/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.util;

import com.netfinworks.common.lang.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueID {
    private static final Logger log = LoggerFactory.getLogger(UniqueID.class);
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static UniqueID me = new UniqueID();
    private String hostAddr;
    private Random random = new SecureRandom();
    private MessageDigest mHasher;
    private UniqueTimer timer = new UniqueTimer();

    private UniqueID() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostAddr = addr.getHostAddress();
        }
        catch (IOException e) {
            log.error("[UniqID] Get HostAddr Error", (Throwable)e);
            this.hostAddr = String.valueOf(System.currentTimeMillis());
        }
        if (StringUtil.isBlank(this.hostAddr) || "127.0.0.1".equals(this.hostAddr)) {
            this.hostAddr = String.valueOf(System.currentTimeMillis());
        }
        if (log.isDebugEnabled()) {
            log.debug("[UniqID]hostAddr is:" + this.hostAddr);
        }
        try {
            this.mHasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nex) {
            this.mHasher = null;
            log.error("[UniqID]new MD% Hasher error", (Throwable)nex);
        }
    }

    public static UniqueID getInstance() {
        return me;
    }

    public String getUniqueID() {
        StringBuffer sb = new StringBuffer();
        long t = this.timer.getCurrentTime();
        sb.append(t);
        sb.append("-");
        sb.append(this.random.nextInt(8999) + 1000);
        sb.append("-");
        sb.append(this.hostAddr);
        sb.append("-");
        sb.append(Thread.currentThread().hashCode());
        if (log.isDebugEnabled()) {
            log.debug("[UniqID.getUniqID]" + sb.toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueIDHash() {
        String id = this.getUniqueID();
        if (this.mHasher != null) {
            MessageDigest messageDigest = this.mHasher;
            synchronized (messageDigest) {
                byte[] bt = this.mHasher.digest(id.getBytes());
                int l = bt.length;
                char[] out = new char[l << 1];
                int j = 0;
                for (int i = 0; i < l; ++i) {
                    out[j++] = digits[(0xF0 & bt[i]) >>> 4];
                    out[j++] = digits[0xF & bt[i]];
                }
                if (log.isDebugEnabled()) {
                    log.debug("[UniqID.getuniqIDHash]" + new String(out));
                }
                return new String(out);
            }
        }
        return id;
    }

    private static class UniqueTimer {
        private long lastTime = System.currentTimeMillis();

        private UniqueTimer() {
        }

        public synchronized long getCurrentTime() {
            long currTime = System.currentTimeMillis();
            this.lastTime = Math.max(this.lastTime + 1L, currTime);
            return this.lastTime;
        }
    }
}

