/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.common.util;

import com.netfinworks.common.lang.StringUtil;
import com.netfinworks.common.util.money.Money;
import com.netfinworks.validate.exception.ValidationException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityUtil {
    private static VelocityEngine ve = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VelocityEngine loadEngine() {
        if (ve != null) {
            return ve;
        }
        Class<VelocityUtil> clazz = VelocityUtil.class;
        synchronized (VelocityUtil.class) {
            if (ve != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ve;
            }
            VelocityEngine tempVe = new VelocityEngine();
            try {
                tempVe.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ve = tempVe;
            // ** MonitorExit[var0] (shouldn't be in output)
            return ve;
        }
    }

    public static String getString(String templateContent, Map<String, Object> paramMap) throws ValidationException {
        if (StringUtil.isBlank(templateContent)) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        if (paramMap != null && paramMap.size() > 0) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        StringWriter writer = new StringWriter();
        try {
            VelocityUtil.loadEngine().evaluate((Context)context, (Writer)writer, "velocity", templateContent);
            return writer.toString();
        }
        catch (Exception e) {
            throw new ValidationException("\u8868\u8fbe\u5f0f[" + templateContent + "]\u4e0d\u7b26\u5408\u89c4\u8303", e);
        }
    }

    public static String mergeString(String templateContent, Map<String, Object> paramMap) throws ValidationException {
        return VelocityUtil.getString(VelocityUtil.wrapExecuteContent(templateContent), paramMap);
    }

    public static String executeString(String templateContent, Map<String, Object> paramMap) throws ValidationException {
        if (StringUtil.contains(templateContent, "#if")) {
            return VelocityUtil.getString(templateContent, paramMap);
        }
        return VelocityUtil.mergeString(templateContent, paramMap);
    }

    public static boolean isTrue(String templateContent, Map<String, Object> paramMap) throws ValidationException {
        return Boolean.valueOf(StringUtil.trim(VelocityUtil.executeString(templateContent, paramMap)));
    }

    public static Money getAmount(String templateContent, Map<String, Money> paramMap) throws ValidationException {
        Money emptyAmount = new Money("0");
        if (StringUtil.isBlank(templateContent) || paramMap == null) {
            return emptyAmount;
        }
        HashMap<String, Object> amountMap = new HashMap<String, Object>();
        for (Map.Entry<String, Money> entry : paramMap.entrySet()) {
            amountMap.put(entry.getKey(), entry.getValue().getAmount());
        }
        String resultString = VelocityUtil.executeString(templateContent, amountMap);
        if (StringUtil.isBlank(resultString)) {
            return emptyAmount;
        }
        return new Money(StringUtil.trim(resultString));
    }

    public static String warpVariable(String orgiValue) {
        return "${" + orgiValue + "}";
    }

    private static String wrapExecuteContent(String orgiContent) {
        return "#set($temp=" + orgiContent + ")$temp";
    }

    public static void main(String[] args) {
        try {
            String test = "#if(${test1}>2) true #else false #end";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("test1", 3);
            System.out.println(VelocityUtil.executeString(test, paramMap));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

