package com.netfinworks.mq.jms;

import javax.jms.JMSException;

import com.netfinworks.mq.core.MQAccessor;
import com.netfinworks.mq.core.MQException;
import com.netfinworks.mq.request.MQRequest;

public interface JmsAccessor extends MQAccessor {
	/**
	 * 发送消息
	 * @param destination		目的地名称
	 * @param destinationType	目的地类型
	 * @param request			消息请求对象
	 * @throws JMSException
	 */
	void sendMessage(String destination, int destinationType,
			MQRequest request) throws JMSException;

	
	/**
	 * 发送消息
	 * @param destination		目的地名称
	 * @param destinationType	目的地类型
	 * @param messageFormat		消息传输格式
	 * @param transacted		是否支持事务
	 * @param acknowledgeMode	应答模式
	 * @param deliveryMode		传递模式（是否持久化）
	 * @param request			消息内容
	 * @throws JMSException
	 */
	void sendMessage(String destination, int destinationType, int messageFormat, 
			boolean transacted, int acknowledgeMode, int deliveryMode,
			Object request) throws JMSException;
	
	Object receiveMessage(String queueName) throws MQException;
	
	Object receiveMessage(String destination, int destinationType, 
			boolean transacted, int acknowledgeMode, String selector) throws MQException;
}
