package com.netfinworks.mq.jms.impl;

import java.util.HashMap;
import java.util.Map;

import com.netfinworks.mq.management.model.DestinationInfo;
import com.netfinworks.mq.management.service.DestinationInfoService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DestinationInfoFactory {
    private Log logger = LogFactory.getLog(DestinationInfoFactory.class);
    private Map<Integer, DestinationInfo> cachedDestinationInfo = new HashMap<Integer, DestinationInfo>(100);
    private DestinationInfoService destinationInfoService;

    public DestinationInfo getDestinationInfo(Integer actionId) {
        DestinationInfo destinationInfo = cachedDestinationInfo.get(actionId);

        if (destinationInfo == null) {
            try {
                destinationInfo = getDestinationInfoService().findByActionId(actionId);
            } catch (Exception e) {
                logger.warn("Cannot find destination from actionId: " + actionId);
            }

            if (destinationInfo == null) {
                return null;
            }

            cachedDestinationInfo.put(actionId, destinationInfo);
        }

        return destinationInfo;
    }

    public void setDestinationInfoService(
            DestinationInfoService destinationInfoService) {
        this.destinationInfoService = destinationInfoService;
    }

    public DestinationInfoService getDestinationInfoService() {
        return destinationInfoService;
    }
}
