package com.netfinworks.mq.jms.impl;

import java.util.HashMap;
import java.util.Map;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;


import com.netfinworks.mq.constant.DestinationType;
import com.netfinworks.mq.jms.DestinationResolver;

public class DestinationResolverImpl implements DestinationResolver {

    private Map<String, Destination> cachedDestination = new HashMap<String, Destination>();
    private static DestinationResolver destinationResolver = new DestinationResolverImpl();

    private DestinationResolverImpl() {
    }

    public static DestinationResolver getInstance() {
        return destinationResolver;
    }

    public Destination getDestination(Session session, String destinationName,
            int destinationType) throws JMSException {
        Destination destination = cachedDestination.get(destinationName);

        if (destination == null) {
            if (destinationType == DestinationType.QUEUE) {
                destination = session.createQueue(destinationName);
            } else if (destinationType == DestinationType.TOPIC) {
                destination = session.createTopic(destinationName);
            }

            cachedDestination.put(destinationName, destination);
        }

        return destination;
    }

    public Destination resolveDestinationName(Session session,
            String destinationName, boolean pubSubDomain) throws JMSException {
        Destination destination = cachedDestination.get(destinationName);

        if (destination == null) {
            if (pubSubDomain) {
                destination = session.createTopic(destinationName);
            } else {
                destination = session.createQueue(destinationName);
            }

            cachedDestination.put(destinationName, destination);
        }

        return destination;
    }
}
