/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.impl;

import com.netfinworks.mq.management.model.DestinationInfo;
import com.netfinworks.mq.management.service.DestinationInfoService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DestinationInfoFactory {
    private Log logger = LogFactory.getLog(DestinationInfoFactory.class);
    private Map<Integer, DestinationInfo> cachedDestinationInfo = new HashMap<Integer, DestinationInfo>(100);
    private DestinationInfoService destinationInfoService;

    public DestinationInfo getDestinationInfo(Integer actionId) {
        DestinationInfo destinationInfo = this.cachedDestinationInfo.get(actionId);
        if (destinationInfo == null) {
            try {
                destinationInfo = this.getDestinationInfoService().findByActionId(actionId);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Cannot find destination from actionId: " + actionId));
            }
            if (destinationInfo == null) {
                return null;
            }
            this.cachedDestinationInfo.put(actionId, destinationInfo);
        }
        return destinationInfo;
    }

    public void setDestinationInfoService(DestinationInfoService destinationInfoService) {
        this.destinationInfoService = destinationInfoService;
    }

    public DestinationInfoService getDestinationInfoService() {
        return this.destinationInfoService;
    }
}

