/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.impl;

import com.netfinworks.mq.core.MQException;
import com.netfinworks.mq.jms.JmsAccessor;
import com.netfinworks.mq.jms.impl.DestinationInfoFactory;
import com.netfinworks.mq.jms.impl.JmsTemplate;
import com.netfinworks.mq.jms.surport.MessageConvert;
import com.netfinworks.mq.management.model.DestinationInfo;
import com.netfinworks.mq.request.MQRequest;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.MessageCreator;
import org.springframework.util.Assert;

public class JmsAccessorImpl
implements JmsAccessor {
    private JmsTemplate jmsTemplate;
    private DestinationInfoFactory destinationInfoFactory;

    public void sendMessage(MQRequest request) throws MQException {
        DestinationInfo destinationInfo = this.resolveDestination(request.getActionId());
        request.setDestination(destinationInfo.getDestination());
        request.setDestinationType(destinationInfo.getDestinationType());
        try {
            this.sendMessage(request.getDestination(), request.getDestinationType(), request);
        }
        catch (JMSException e) {
            throw new MQException("Send message failed.", (Throwable)e);
        }
    }

    @Override
    public void sendMessage(String destination, int destinationType, MQRequest request) throws JMSException {
        this.sendMessage(destination, destinationType, request.getMessageFormat(), request.isTransacted(), request.getAcknowledgeMode(), request.getDeliveryMode(), request);
    }

    @Override
    public void sendMessage(String destination, int destinationType, final int messageFormat, boolean transacted, int acknowledgeMode, final int deliveryMode, final Object request) throws JMSException {
        this.jmsTemplate.send(destination, destinationType, transacted, acknowledgeMode, deliveryMode, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                Message message = MessageConvert.toMessage(session, request, messageFormat);
                message.setJMSDeliveryMode(deliveryMode);
                if (request instanceof MQRequest) {
                    JmsAccessorImpl.this.setMessageProperties(message, ((MQRequest)request).getProperties());
                }
                return message;
            }
        });
    }

    public Object receiveMessage(int actionId) throws MQException {
        return this.receiveMessage(actionId, false, 3, null);
    }

    public Object receiveMessage(int actionId, boolean transacted, int acknowledgeMode, String selector) throws MQException {
        Assert.notNull((Object)actionId, (String)"MQRequest action id cannot be null.");
        Assert.isTrue((actionId > 0 ? 1 : 0) != 0, (String)"MQRequest action id must be greater than zero.");
        DestinationInfo destinationInfo = this.resolveDestination(actionId);
        return this.receiveMessage(destinationInfo.getDestination(), destinationInfo.getDestinationType(), transacted, acknowledgeMode, selector);
    }

    @Override
    public Object receiveMessage(String queueName) throws MQException {
        return this.receiveMessage(queueName, 0);
    }

    public Object receiveMessage(String destination, int destinationType) throws MQException {
        return this.receiveMessage(destination, destinationType, null);
    }

    public Object receiveMessage(String destination, int destinationType, String selector) throws MQException {
        return this.receiveMessage(destination, destinationType, false, 1, selector);
    }

    @Override
    public Object receiveMessage(String destination, int destinationType, boolean transacted, int acknowledgeMode, String selector) throws MQException {
        try {
            Message message = this.jmsTemplate.receiveSelected(destination, destinationType, transacted, acknowledgeMode, selector);
            if (message == null) {
                return null;
            }
            return MessageConvert.fromMessage(message);
        }
        catch (JmsException e) {
            throw new MQException("Receive message failed.", (Throwable)e);
        }
        catch (JMSException e) {
            throw new MQException("Message received is invalid.", (Throwable)e);
        }
    }

    private void setMessageProperties(Message message, Map<String, Object> props) throws JMSException {
        if (props == null || props.isEmpty()) {
            return;
        }
        Set<String> keys = props.keySet();
        for (String key : keys) {
            Object value = props.get(key);
            if (value instanceof String) {
                message.setStringProperty(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                message.setIntProperty(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Boolean) {
                message.setBooleanProperty(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Long) {
                message.setLongProperty(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                message.setDoubleProperty(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                message.setFloatProperty(key, ((Float)value).floatValue());
                continue;
            }
            message.setObjectProperty(key, value);
        }
    }

    private DestinationInfo resolveDestination(Integer actionId) {
        Assert.notNull((Object)actionId, (String)"MQRequest action id cannot be null.");
        Assert.isTrue((actionId > 0 ? 1 : 0) != 0, (String)"MQRequest action id must be greater than zero.");
        DestinationInfo destinationInfo = this.destinationInfoFactory.getDestinationInfo(actionId);
        if (destinationInfo == null) {
            throw new IllegalArgumentException("Invalid actionId.");
        }
        return destinationInfo;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setDestinationInfoFactory(DestinationInfoFactory destinationInfoFactory) {
        this.destinationInfoFactory = destinationInfoFactory;
    }
}

