/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.impl;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;

public class JmsTemplate
extends org.springframework.jms.core.JmsTemplate {
    protected Session createSession(Connection connection, boolean transacted, int acknowledgeMode) throws JMSException {
        return connection.createSession(transacted, acknowledgeMode);
    }

    public Object execute(SessionCallback action, boolean transacted, int acknowledgeMode, boolean startConnection) throws JmsException {
        Object object;
        Assert.notNull((Object)action, (String)"Callback object must not be null");
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            conToClose = this.createConnection();
            sessionToClose = this.createSession(conToClose);
            if (startConnection) {
                conToClose.start();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on JMS Session: " + sessionToClose));
            }
            object = action.doInJms(sessionToClose);
        }
        catch (JMSException ex) {
            try {
                throw this.convertJmsAccessException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(sessionToClose);
                ConnectionFactoryUtils.releaseConnection((Connection)conToClose, (ConnectionFactory)this.getConnectionFactory(), (boolean)startConnection);
                throw throwable;
            }
        }
        JmsUtils.closeSession((Session)sessionToClose);
        ConnectionFactoryUtils.releaseConnection((Connection)conToClose, (ConnectionFactory)this.getConnectionFactory(), (boolean)startConnection);
        return object;
    }

    public void send(final String destinationName, final int destinationType, boolean transacted, int acknowledgeMode, final int deliveryMode, final MessageCreator messageCreator) throws JmsException {
        this.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName, destinationType);
                JmsTemplate.this.doSend(session, destination, messageCreator, deliveryMode);
                return null;
            }
        }, transacted, acknowledgeMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Session session, Destination destination, MessageCreator messageCreator, int deliveryMode) throws JMSException {
        Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
        MessageProducer producer = this.createProducer(session, destination);
        try {
            Message message = messageCreator.createMessage(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending created message: " + message));
            }
            producer.send(message, deliveryMode, this.getPriority(), this.getTimeToLive());
            if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary((Session)session);
            }
        }
        finally {
            JmsUtils.closeMessageProducer((MessageProducer)producer);
        }
    }

    public Message receiveSelected(final String destinationName, final int destinationType, boolean transacted, int acknowledgeMode, final String messageSelector) throws JmsException {
        return (Message)this.execute(new SessionCallback(){

            public Message doInJms(Session session) throws JMSException {
                Destination destination = JmsTemplate.this.resolveDestinationName(session, destinationName, destinationType);
                return JmsTemplate.this.doReceive(session, destination, messageSelector);
            }
        }, transacted, acknowledgeMode, false);
    }

    protected Destination resolveDestinationName(Session session, String destinationName, int destinationType) throws JMSException {
        boolean pubSubDomain = destinationType == 3;
        return this.getDestinationResolver().resolveDestinationName(session, destinationName, pubSubDomain);
    }
}

