/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.mq.jms.surport;

import com.netfinworks.marshaller.json.JsonMarshaller;
import com.netfinworks.mq.request.MQRequest;
import com.netfinworks.mq.request.notify.NotifyRequest;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;

public class MessageConvert {
    public static Message toMessage(Session session, Object request, int messageFormat) throws JMSException {
        if (request instanceof Message) {
            return (Message)request;
        }
        if (request instanceof MQRequest) {
            MQRequest mqRequest = (MQRequest)request;
            if (messageFormat == 2) {
                return MessageConvert.createTextMessage(session, JsonMarshaller.marshall((Object)request));
            }
            if (messageFormat == 1) {
                return MessageConvert.createObjectMessage(session, (Serializable)mqRequest);
            }
            NotifyRequest notifyRequest = (NotifyRequest)mqRequest;
            if (messageFormat == 3) {
                return MessageConvert.createTextMessage(session, (String)notifyRequest.getContent());
            }
            if (messageFormat == 4) {
                return MessageConvert.createMapMessage(session, (Map)notifyRequest.getContent());
            }
            if (messageFormat == 5) {
                return MessageConvert.createByteArrayMessage((byte[])notifyRequest.getContent(), session);
            }
            throw new IllegalArgumentException("Invalid message type. Message support object, json and map.");
        }
        if (request instanceof String) {
            return MessageConvert.createTextMessage(session, (String)request);
        }
        if (request instanceof byte[]) {
            return MessageConvert.createByteArrayMessage((byte[])request, session);
        }
        if (request instanceof Map) {
            return MessageConvert.createMapMessage(session, (Map)request);
        }
        if (request instanceof Serializable) {
            return MessageConvert.createObjectMessage(session, (Serializable)request);
        }
        throw new IllegalArgumentException("Invalid message type. Message support object, json and map.");
    }

    public static Object fromMessage(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return MessageConvert.extractStringFromMessage((TextMessage)message);
        }
        if (message instanceof BytesMessage) {
            return MessageConvert.extractByteArrayFromMessage((BytesMessage)message);
        }
        if (message instanceof MapMessage) {
            return MessageConvert.extractMapFromMessage((MapMessage)message);
        }
        if (message instanceof ObjectMessage) {
            return MessageConvert.extractSerializableFromMessage((ObjectMessage)message);
        }
        return message;
    }

    private static Message createTextMessage(Session session, String text) throws JMSException {
        TextMessage message = session.createTextMessage();
        message.setText(text);
        return message;
    }

    private static Message createByteArrayMessage(byte[] bytes, Session session) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(bytes);
        return message;
    }

    private static Message createMapMessage(Session session, Map<?, ?> map) throws JMSException {
        MapMessage message = session.createMapMessage();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Cannot convert non-String key of type [" + key.getClass().getName() + "] to JMS MapMessage entry");
            }
            message.setObject((String)key, map.get(key));
        }
        return message;
    }

    private static Message createObjectMessage(Session session, Serializable object) throws JMSException {
        ObjectMessage objMessage = session.createObjectMessage();
        objMessage.setObject(object);
        return objMessage;
    }

    private static String extractStringFromMessage(TextMessage message) throws JMSException {
        return message.getText();
    }

    private static byte[] extractByteArrayFromMessage(BytesMessage message) throws JMSException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        return bytes;
    }

    private static Map<String, Object> extractMapFromMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration en = message.getMapNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            map.put(key, message.getObject(key));
        }
        return map;
    }

    private static Serializable extractSerializableFromMessage(ObjectMessage message) throws JMSException {
        return message.getObject();
    }
}

