/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.basis.inf.ucs.memcached;

import com.netfinworks.basis.inf.ucs.client.CacheEventType;
import com.netfinworks.basis.inf.ucs.client.CacheListener;
import com.netfinworks.basis.inf.ucs.client.CacheRespone;
import com.netfinworks.basis.inf.ucs.memcached.BaseMemcachedClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XUCache<T>
extends BaseMemcachedClient<T> {
    private MemcachedClient memcachedClient;
    private long connectTimeout = 60000L;
    private long opTimeout = 1000L;
    private int connectionPoolSize = 1;
    private Transcoder<T> transcoder;
    private String protocol = "text";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<CacheListener<T>> listeners;

    public void addListener(CacheListener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CacheListener<T>>();
        }
        this.listeners.add(listener);
    }

    public MemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setListener(List<CacheListener<T>> listeners) {
        this.listeners = listeners;
    }

    public void setTranscoder(Transcoder<T> transcoder) {
        this.transcoder = transcoder;
    }

    public void setOpTimeout(long opTimeout) {
        this.opTimeout = opTimeout;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public boolean init() {
        String address = this.getMemcachedNodeAddress();
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)address));
        builder.setConnectionPoolSize(this.connectionPoolSize);
        builder.setConnectTimeout(this.connectTimeout);
        if (this.transcoder != null) {
            builder.setTranscoder(this.transcoder);
        }
        if ("bin".equals(this.protocol)) {
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        }
        try {
            this.memcachedClient = builder.build();
            this.memcachedClient.setOpTimeout(this.opTimeout);
            this.log.debug("XUCache successfully initialized! memcached node info : {}", (Object)address);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.error("XUCache initializing failed! memcached node info : {}", (Object)address);
            return false;
        }
    }

    public CacheRespone<T> get(String key) {
        try {
            Object t = this.memcachedClient.get(key);
            this.fireEvent(new CacheListener.Event(CacheEventType.GET_OK, key, t));
            return new CacheRespone(t);
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GET_EXCEPTION, key, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GET_EXCEPTION, key, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GET_EXCEPTION, key, (Exception)((Object)e)));
        }
        return CacheRespone.failResult();
    }

    public boolean add(String key, T t, int expireSecond) {
        try {
            boolean ret = this.memcachedClient.add(key, expireSecond, t);
            this.log.debug("add [key={},object={},exp={}] {}", new Object[]{key, t, expireSecond, ret ? "successfully" : "failed"});
            if (!ret) {
                this.fireEvent(new CacheListener.Event(CacheEventType.ADD_FAIL, key, t));
            } else {
                this.fireEvent(new CacheListener.Event(CacheEventType.ADD_OK, key, t));
            }
            return ret;
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.ADD_EXCEPTION, key, t, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.ADD_EXCEPTION, key, t, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.ADD_EXCEPTION, key, t, (Exception)((Object)e)));
        }
        return false;
    }

    public boolean set(String key, T t, int expireSecond) {
        try {
            boolean ret = this.memcachedClient.set(key, expireSecond, t);
            this.log.debug("set [key={},object={},exp={}] {}", new Object[]{key, t, expireSecond, ret ? "successfully" : "failed"});
            if (!ret) {
                this.fireEvent(new CacheListener.Event(CacheEventType.SET_FAIL, key, t));
            } else {
                this.fireEvent(new CacheListener.Event(CacheEventType.SET_OK, key, t));
            }
            return ret;
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.SET_EXCEPTION, key, t, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.SET_EXCEPTION, key, t, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.SET_EXCEPTION, key, t, (Exception)((Object)e)));
        }
        return false;
    }

    public boolean touch(String key, int newExpireSecond) {
        try {
            boolean ret = this.memcachedClient.touch(key, newExpireSecond);
            this.fireEvent(new CacheListener.Event(ret ? CacheEventType.TOUCH_OK : CacheEventType.TOUCH_FAIL, key));
            return ret;
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.TOUCH_EXCEPTION, key, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.TOUCH_EXCEPTION, key, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.TOUCH_EXCEPTION, key, (Exception)((Object)e)));
        }
        return false;
    }

    public CacheRespone<T> getAndTouch(String key, int newExpireSecond) {
        try {
            Object t = this.memcachedClient.getAndTouch(key, newExpireSecond);
            this.fireEvent(new CacheListener.Event(CacheEventType.GAT_OK, key));
            return new CacheRespone(t);
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GAT_EXCEPTION, key, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GAT_EXCEPTION, key, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.GAT_EXCEPTION, key, (Exception)((Object)e)));
        }
        return CacheRespone.failResult();
    }

    public boolean delete(String key) {
        try {
            boolean ret = this.memcachedClient.delete(key);
            this.fireEvent(new CacheListener.Event(ret ? CacheEventType.DEL_OK : CacheEventType.DEL_FAIL, key));
            return ret;
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, key, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, key, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, key, (Exception)((Object)e)));
        }
        return false;
    }

    public void flush() {
        try {
            this.memcachedClient.flushAll();
            this.fireEvent(new CacheListener.Event(CacheEventType.FLUSH_OK));
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.DEL_EXCEPTION, (Exception)((Object)e)));
        }
    }

    public boolean destroy() {
        try {
            this.memcachedClient.shutdown();
            return true;
        }
        catch (IOException e) {
            this.log.error("xmemcache io exception", (Throwable)e);
            return false;
        }
    }

    public boolean replace(String key, T t, int expireSecond) {
        try {
            boolean ret = this.memcachedClient.replace(key, expireSecond, t);
            this.fireEvent(new CacheListener.Event(ret ? CacheEventType.REPLACE_OK : CacheEventType.REPLACE_FAIL, key));
            return ret;
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache timeout", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.REPLACE_EXCEPTION, key, t, (Exception)e));
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache interrupted", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.REPLACE_EXCEPTION, key, t, (Exception)e));
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache exception", (Throwable)e);
            this.fireEvent(new CacheListener.Event(CacheEventType.REPLACE_EXCEPTION, key, t, (Exception)((Object)e)));
        }
        return false;
    }

    public CacheRespone<Long> incr(String key, long delta) {
        try {
            long ret = this.memcachedClient.incr(key, delta);
            return new CacheRespone((Object)ret);
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache increase timeout", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache increase interrupted", (Throwable)e);
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache increase exception", (Throwable)e);
        }
        return CacheRespone.failResult();
    }

    public CacheRespone<Long> decr(String key, long delta) {
        try {
            long ret = this.memcachedClient.decr(key, delta);
            return new CacheRespone((Object)ret);
        }
        catch (TimeoutException e) {
            this.log.error("xmemcache decrease timeout", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.log.error("xmemcache decrease interrupted", (Throwable)e);
        }
        catch (MemcachedException e) {
            this.log.error("xmemcache decrease exception", (Throwable)e);
        }
        return CacheRespone.failResult();
    }

    private void fireEvent(CacheListener.Event<T> event) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (CacheListener<T> listener : this.listeners) {
                try {
                    listener.onErroEvent(event);
                }
                catch (Exception ex) {
                    this.log.error("\u7f13\u5b58\u4e8b\u4ef6\u5904\u7406\u5f02\u5e38\uff1alistener = {}, event = {}/{}/{}", new Object[]{listener, event.getKey(), event.getType(), event.getValue()});
                    this.log.error("\u7f13\u5b58\u4e8b\u4ef6\u5904\u7406\u5f02\u5e38", (Throwable)ex);
                }
            }
        }
    }
}

