/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import com.google.common.base.Preconditions;
import com.netflix.curator.ConnectionState;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.SessionFailRetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.drivers.TracerDriver;
import com.netflix.curator.ensemble.EnsembleProvider;
import com.netflix.curator.ensemble.fixed.FixedEnsembleProvider;
import com.netflix.curator.utils.DefaultTracerDriver;
import com.netflix.curator.utils.DefaultZookeeperFactory;
import com.netflix.curator.utils.ZookeeperFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorZookeeperClient
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionState state;
    private final AtomicReference<RetryPolicy> retryPolicy = new AtomicReference();
    private final int connectionTimeoutMs;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicReference<TracerDriver> tracer = new AtomicReference<DefaultTracerDriver>(new DefaultTracerDriver());

    public CuratorZookeeperClient(String string, int n, int n2, Watcher watcher, RetryPolicy retryPolicy) throws IOException {
        this(new DefaultZookeeperFactory(), new FixedEnsembleProvider(string), n, n2, watcher, retryPolicy);
    }

    public CuratorZookeeperClient(EnsembleProvider ensembleProvider, int n, int n2, Watcher watcher, RetryPolicy retryPolicy) throws IOException {
        this(new DefaultZookeeperFactory(), ensembleProvider, n, n2, watcher, retryPolicy);
    }

    public CuratorZookeeperClient(ZookeeperFactory zookeeperFactory, EnsembleProvider ensembleProvider, int n, int n2, Watcher watcher, RetryPolicy retryPolicy) throws IOException {
        retryPolicy = (RetryPolicy)Preconditions.checkNotNull((Object)retryPolicy, (Object)"retryPolicy cannot be null");
        ensembleProvider = (EnsembleProvider)Preconditions.checkNotNull((Object)ensembleProvider, (Object)"ensembleProvider cannot be null");
        this.connectionTimeoutMs = n2;
        this.state = new ConnectionState(zookeeperFactory, ensembleProvider, n, n2, watcher, this.tracer);
        this.setRetryPolicy(retryPolicy);
    }

    public ZooKeeper getZooKeeper() throws Exception {
        return this.state.getZooKeeper();
    }

    public RetryLoop newRetryLoop() {
        return new RetryLoop(this.retryPolicy.get(), this.tracer);
    }

    public SessionFailRetryLoop newSessionFailRetryLoop(SessionFailRetryLoop.Mode mode) {
        return new SessionFailRetryLoop(this, mode);
    }

    public boolean isConnected() {
        return this.state.isConnected();
    }

    public boolean blockUntilConnectedOrTimedOut() throws InterruptedException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"Client is not started");
        this.log.debug("blockUntilConnectedOrTimedOut() start");
        TimeTrace timeTrace = this.startTracer("blockUntilConnectedOrTimedOut");
        this.internalBlockUntilConnectedOrTimedOut();
        timeTrace.commit();
        boolean bl = this.state.isConnected();
        this.log.debug("blockUntilConnectedOrTimedOut() end. isConnected: " + bl);
        return bl;
    }

    public void start() throws Exception {
        this.log.debug("Starting");
        if (!this.started.compareAndSet(false, true)) {
            IllegalStateException illegalStateException = new IllegalStateException();
            this.log.error("Already started", (Throwable)illegalStateException);
            throw illegalStateException;
        }
        this.state.start();
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        this.started.set(false);
        try {
            this.state.close();
        }
        catch (IOException iOException) {
            this.log.error("", (Throwable)iOException);
        }
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        Preconditions.checkNotNull((Object)retryPolicy, (Object)"policy cannot be null");
        this.retryPolicy.set(retryPolicy);
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy.get();
    }

    public TimeTrace startTracer(String string) {
        return new TimeTrace(string, this.tracer.get());
    }

    public TracerDriver getTracerDriver() {
        return this.tracer.get();
    }

    public void setTracerDriver(TracerDriver tracerDriver) {
        this.tracer.set(tracerDriver);
    }

    void addParentWatcher(Watcher watcher) {
        this.state.addParentWatcher(watcher);
    }

    void removeParentWatcher(Watcher watcher) {
        this.state.removeParentWatcher(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalBlockUntilConnectedOrTimedOut() throws InterruptedException {
        long l;
        for (long i = (long)this.connectionTimeoutMs; !this.state.isConnected() && i > 0L; i -= l) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    countDownLatch.countDown();
                }
            };
            this.state.addParentWatcher(watcher);
            long l2 = System.currentTimeMillis();
            try {
                countDownLatch.await(1L, TimeUnit.SECONDS);
            }
            finally {
                this.state.removeParentWatcher(watcher);
            }
            l = Math.max(1L, System.currentTimeMillis() - l2);
        }
    }
}

