/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.modes;

import com.nbcb.bouncycastle.crypto.BlockCipher;
import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.crypto.DataLengthException;
import com.nbcb.bouncycastle.crypto.SkippingStreamCipher;
import com.nbcb.bouncycastle.crypto.StreamBlockCipher;
import com.nbcb.bouncycastle.crypto.params.ParametersWithIV;
import com.nbcb.bouncycastle.util.Arrays;
import com.nbcb.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;
    private int byteCount;

    public SICBlockCipher(BlockCipher c) {
        super(c);
        this.cipher = c;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
        this.byteCount = 0;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            int maxCounterSize;
            ParametersWithIV ivParam = (ParametersWithIV)params;
            this.IV = Arrays.clone(ivParam.getIV());
            if (this.blockSize < this.IV.length) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: " + this.blockSize + " bytes.");
            }
            int n = maxCounterSize = 8 > this.blockSize / 2 ? this.blockSize / 2 : 8;
            if (this.blockSize - this.IV.length > maxCounterSize) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: " + (this.blockSize - maxCounterSize) + " bytes.");
            }
            if (ivParam.getParameters() != null) {
                this.cipher.init(true, ivParam.getParameters());
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.blockSize, out, outOff);
        return this.blockSize;
    }

    @Override
    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.byteCount == 0) {
            this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
            return (byte)(this.counterOut[this.byteCount++] ^ in);
        }
        byte rv = (byte)(this.counterOut[this.byteCount++] ^ in);
        if (this.byteCount == this.counter.length) {
            this.byteCount = 0;
            this.incrementCounterAt(0);
            this.checkCounter();
        }
        return rv;
    }

    private void checkCounter() {
        if (this.IV.length < this.blockSize) {
            for (int i = 0; i != this.IV.length; ++i) {
                if (this.counter[i] == this.IV[i]) continue;
                throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
            }
        }
    }

    private void incrementCounterAt(int pos) {
        int i = this.counter.length - pos;
        while (--i >= 0) {
            int n = i;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] == 0) continue;
            break;
        }
    }

    private void incrementCounter(int offSet) {
        byte old = this.counter[this.counter.length - 1];
        int n = this.counter.length - 1;
        this.counter[n] = (byte)(this.counter[n] + offSet);
        if (old != 0 && this.counter[this.counter.length - 1] < old) {
            this.incrementCounterAt(1);
        }
    }

    private void decrementCounterAt(int pos) {
        int i = this.counter.length - pos;
        while (--i >= 0) {
            int n = i;
            this.counter[n] = (byte)(this.counter[n] - 1);
            if (this.counter[n] == -1) continue;
            return;
        }
    }

    private void adjustCounter(long n) {
        if (n >= 0L) {
            long numBlocks = (n + (long)this.byteCount) / (long)this.blockSize;
            long rem = numBlocks;
            if (rem > 255L) {
                for (int i = 5; i >= 1; --i) {
                    long diff = 1L << 8 * i;
                    while (rem >= diff) {
                        this.incrementCounterAt(i);
                        rem -= diff;
                    }
                }
            }
            this.incrementCounter((int)rem);
            this.byteCount = (int)(n + (long)this.byteCount - (long)this.blockSize * numBlocks);
        } else {
            long numBlocks = (-n - (long)this.byteCount) / (long)this.blockSize;
            long rem = numBlocks;
            if (rem > 255L) {
                for (int i = 5; i >= 1; --i) {
                    long diff = 1L << 8 * i;
                    while (rem > diff) {
                        this.decrementCounterAt(i);
                        rem -= diff;
                    }
                }
            }
            for (long i = 0L; i != rem; ++i) {
                this.decrementCounterAt(0);
            }
            int gap = (int)((long)this.byteCount + n + (long)this.blockSize * numBlocks);
            if (gap >= 0) {
                this.byteCount = 0;
            } else {
                this.decrementCounterAt(0);
                this.byteCount = this.blockSize + gap;
            }
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.counter, (byte)0);
        System.arraycopy(this.IV, 0, this.counter, 0, this.IV.length);
        this.cipher.reset();
        this.byteCount = 0;
    }

    @Override
    public long skip(long numberOfBytes) {
        this.adjustCounter(numberOfBytes);
        this.checkCounter();
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        return numberOfBytes;
    }

    @Override
    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    @Override
    public long getPosition() {
        byte[] res = new byte[this.counter.length];
        System.arraycopy(this.counter, 0, res, 0, res.length);
        for (int i = res.length - 1; i >= 1; --i) {
            int v = i < this.IV.length ? (res[i] & 0xFF) - (this.IV[i] & 0xFF) : res[i] & 0xFF;
            if (v < 0) {
                int n = i - 1;
                res[n] = (byte)(res[n] - 1);
                v += 256;
            }
            res[i] = (byte)v;
        }
        return Pack.bigEndianToLong(res, res.length - 8) * (long)this.blockSize + (long)this.byteCount;
    }
}

