/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.agreement.DHStandardGroups;
import com.nbcb.bouncycastle.crypto.params.DHParameters;
import com.nbcb.bouncycastle.crypto.tls.AbstractTlsServer;
import com.nbcb.bouncycastle.crypto.tls.TlsCipherFactory;
import com.nbcb.bouncycastle.crypto.tls.TlsCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsDHEKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsECDHEKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsFatalAlert;
import com.nbcb.bouncycastle.crypto.tls.TlsKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsRSAKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    public DefaultTlsServer() {
    }

    public DefaultTlsServer(TlsCipherFactory cipherFactory) {
        super(cipherFactory);
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49200, 49199, 49192, 49191, 49172, 49171, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47};
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 11: 
            case 20: {
                return null;
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(keyExchangeAlgorithm);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(keyExchangeAlgorithm);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) {
        return new TlsDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.getDHParameters());
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) {
        return new TlsDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.getDHParameters());
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) {
        return new TlsECDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) {
        return new TlsECDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

