/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.jcajce.provider.symmetric;

import com.nbcb.bouncycastle.crypto.BlockCipher;
import com.nbcb.bouncycastle.crypto.CipherKeyGenerator;
import com.nbcb.bouncycastle.crypto.engines.TwofishEngine;
import com.nbcb.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import com.nbcb.bouncycastle.crypto.macs.GMac;
import com.nbcb.bouncycastle.crypto.modes.CBCBlockCipher;
import com.nbcb.bouncycastle.crypto.modes.GCMBlockCipher;
import com.nbcb.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.nbcb.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public final class Twofish {
    private Twofish() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Twofish.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Twofish", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.Twofish", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Twofish", PREFIX + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
            provider.addAlgorithm("Cipher.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHA");
            provider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHAKeyFactory");
            this.addGMacAlgorithm(provider, "Twofish", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "Twofish", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class PBEWithSHA
    extends BaseBlockCipher {
        public PBEWithSHA() {
            super(new CBCBlockCipher(new TwofishEngine()), 2, 1, 256, 16);
        }
    }

    public static class PBEWithSHAKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAKeyFactory() {
            super("PBEwithSHAandTwofish-CBC", null, true, 2, 1, 256, 128);
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Twofish", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.nbcb.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new TwofishEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new TwofishEngine();
                }
            });
        }
    }
}

