/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import com.nbcb.sdk.AbstractBussinessBean;
import com.nbcb.sdk.CommonResponse;
import com.nbcb.sdk.SDKRequestHead;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.utils.JsonUtils;
import com.nbcb.sdk.gm.SM3Utils;
import com.nbcb.sdk.gm.Utils;
import com.nbcb.sdk.gm.gmnew.SM4Utils;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.JsonHelperFactory;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.util.HashMap;
import java.util.Map;

public class CommonSecurityService {
    private static final Log log = NbczLogger.getLog(CommonSecurityService.class);

    public static byte[] encryService(AbstractBussinessBean bean, SDKRequestHead head, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws SDKException {
        byte[] value = null;
        try {
            StringBuilder reqSB = new StringBuilder("{");
            String headJson = JsonUtils.objToJSON(head);
            JsonUtils.appendStruct(reqSB, "Head", headJson, true);
            String dataJson = bean.ReqToJsonString();
            JsonUtils.appendStruct(reqSB, "Data", dataJson, false);
            String reqJson = reqSB.toString();
            byte[] reqByte = reqJson.getBytes("UTF-8");
            value = CommonSecurityService.encry(reqByte, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return value;
    }

    public static byte[] encryService(String reqJson, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws SDKException {
        byte[] value = null;
        try {
            byte[] reqByte = reqJson.getBytes("UTF-8");
            value = CommonSecurityService.encry(reqByte, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return value;
    }

    public static String encryServiceString(String reqJson, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws SDKException {
        String encryStr = null;
        try {
            byte[] reqByte = reqJson.getBytes("UTF-8");
            encryStr = CommonSecurityService.encryString(reqByte, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return encryStr;
    }

    private static byte[] encry(byte[] reqByte, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        String reqStr = CommonSecurityService.encryString(reqByte, randomKey, cntrKey, syncKey);
        byte[] value = reqStr.toString().getBytes("UTF-8");
        return value;
    }

    private static String encryString(byte[] reqByte, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u5bc6\u524d\u7684\u8bf7\u6c42\u62a5\u6587=[" + new String(reqByte, "UTF-8") + "]");
        }
        StringBuilder reqSB = new StringBuilder("{");
        byte[] shaValue = SM3Utils.hash(reqByte);
        byte[] signValueBytes = SM4Utils.encryptData_ECB(cntrKey, shaValue);
        JsonUtils.appendField(reqSB, "ScrtSgn", Utils.encryptByBASE64(signValueBytes), true);
        byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
        JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
        byte[] randomKeyByAES = SM4Utils.encryptData_ECB(syncKey, randomKey);
        JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByAES), false);
        return reqSB.toString();
    }

    public static boolean decryService(AbstractBussinessBean bean, byte[] json, byte[] randomKey, byte[] cntrKey) throws Exception {
        boolean dev = false;
        String respJson = CommonSecurityService.decry(json, randomKey, cntrKey);
        Map<String, String> map = JsonUtils.getMapObj(respJson);
        String headStr = map.get("Head");
        String dataStr = map.get("Data");
        bean.parseReponseJson(dataStr);
        CommonResponse head = JsonUtils.jsonToObj(headStr, CommonResponse.class);
        CommonResponse resp = bean.getResp();
        String inErCode = head.getTxn_Rsp_Cd_Dsc();
        if ("000000".equals(inErCode) || "OPN0100014".equals(inErCode)) {
            resp.setTxn_Rsp_Cd_Dsc(head.getSYS_RESP_CODE());
            resp.setTxn_Rsp_Inf(head.getSYS_RESP_DESC());
            if ("OPN0100014".equals(inErCode)) {
                dev = true;
            }
        } else if ("OPN0100003".equals(inErCode)) {
            dev = true;
        }
        resp.setRqs_Jrnl_No(head.getRqs_Jrnl_No());
        resp.setRsp_Dt(head.getRsp_Dt());
        resp.setRsp_Tm(head.getRsp_Tm());
        resp.setTxn_Rsp_Cd_Dsc(head.getTxn_Rsp_Cd_Dsc());
        resp.setTxn_Rsp_Inf(head.getTxn_Rsp_Inf());
        bean.setResp(resp);
        return dev;
    }

    public static Map<String, Object> decryService(byte[] json, byte[] randomKey, byte[] cntrKey) throws Exception {
        Map<String, Object> result = CommonSecurityService.decryService(new String(json, "UTF-8"), randomKey, cntrKey);
        return result;
    }

    public static String decryServiceString(String json, byte[] randomKey, byte[] cntrKey) throws Exception {
        String respJson = "";
        Map<String, Object> resultMap = CommonSecurityService.decryService(json, randomKey, cntrKey);
        if (null != resultMap) {
            respJson = (String)resultMap.get("respValue");
        }
        return respJson;
    }

    public static Map<String, Object> decryService(String json, byte[] randomKey, byte[] cntrKey) throws Exception {
        boolean dev = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String respJson = CommonSecurityService.decryString(json, randomKey, cntrKey);
        JsonHelper jsonHelper = JsonHelperFactory.getInstance().getJsonHelper();
        Map<String, Object> resMap = jsonHelper.getMapObj(respJson, Object.class);
        String headStr = jsonHelper.toJSONString(resMap.get("Head"));
        String dataStr = jsonHelper.toJSONString(resMap.get("Data"));
        Map<String, String> headMap = JsonUtils.getMapObj(headStr);
        String ircd = headMap.get("Txn_Rsp_Cd_Dsc");
        if ("000000".equals(ircd) || "OPN0100014".equals(ircd)) {
            headMap.put("Txn_Rsp_Cd_Dsc", headMap.get("SYS_RESP_CODE"));
            headMap.put("Txn_Rsp_Inf", headMap.get("SYS_RESP_DESC"));
            if ("OPN0100014".equals(ircd)) {
                dev = true;
            }
        } else if ("OPN0100003".equals(ircd)) {
            dev = true;
        }
        headMap.remove("SYS_RESP_CODE");
        headMap.remove("SYS_RESP_DESC");
        String header = JsonUtils.objToJSON(headMap);
        StringBuilder sb = new StringBuilder("{");
        JsonUtils.appendStruct(sb, "Head", header, true);
        JsonUtils.appendStruct(sb, "Data", dataStr, false);
        result.put("respValue", sb.toString());
        result.put("dev", dev);
        return result;
    }

    private static String decry(byte[] respJsonByte, byte[] randomKey, byte[] cntrKey) throws Exception {
        String respJson = CommonSecurityService.decryString(new String(respJsonByte, "UTF-8"), randomKey, cntrKey);
        return respJson;
    }

    private static String decryString(String respJson, byte[] randomKey, byte[] cntrKey) throws Exception {
        byte[] shaValue;
        byte[] signValueBytes;
        String sgnStr;
        boolean checkSignValue;
        if (CommonSecurityService.isTokenInval(respJson)) {
            return respJson;
        }
        Map<String, String> map = JsonUtils.getMapObj(respJson);
        String scrtData = map.get("ScrtData");
        String sgn = map.get("ScrtSgn");
        byte[] respByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(scrtData));
        String respMsg = new String(respByte, "UTF-8");
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u5bc6\u540e\u7684\u54cd\u5e94\u62a5\u6587=[" + respMsg + "]");
        }
        if (!(checkSignValue = (sgnStr = Utils.encryptByBASE64(signValueBytes = SM4Utils.encryptData_ECB(cntrKey, shaValue = SM3Utils.hash(respByte)))).equals(sgn))) {
            throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
        }
        return respMsg;
    }

    private static boolean isTokenInval(String json) {
        try {
            Map<String, String> headMap;
            String ircd;
            Map<String, String> resMap = JsonUtils.getMapObj(json);
            String headStr = resMap.get("Head");
            if (null != headStr && !"".equals(headStr) && (ircd = (headMap = JsonUtils.getMapObj(headStr)).get("Txn_Rsp_Cd_Dsc")).equals("OPN0100003")) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("token inval error");
        }
        return false;
    }

    public static byte[] encryService(String appkey, String reqJson, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws SDKException {
        byte[] value = null;
        try {
            byte[] reqByte = reqJson.getBytes("UTF-8");
            value = CommonSecurityService.encry(appkey, reqByte, randomKey, cntrKey, syncKey);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return value;
    }

    private static byte[] encry(String appkey, byte[] reqByte, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        String reqStr = CommonSecurityService.encryString(appkey, reqByte, randomKey, cntrKey, syncKey);
        byte[] value = reqStr.toString().getBytes("UTF-8");
        return value;
    }

    private static String encryString(String appkey, byte[] reqByte, byte[] randomKey, byte[] cntrKey, byte[] syncKey) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u5bc6\u524d\u7684\u8bf7\u6c42\u62a5\u6587=[" + new String(reqByte, "UTF-8") + "]");
        }
        StringBuilder reqSB = new StringBuilder("{");
        byte[] shaValue = SM3Utils.hash(reqByte);
        byte[] signValueBytes = SM4Utils.encryptData_ECB(cntrKey, shaValue);
        JsonUtils.appendField(reqSB, "ScrtSgn", Utils.encryptByBASE64(signValueBytes), true);
        byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
        JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
        byte[] randomKeyByAES = SM4Utils.encryptData_ECB(syncKey, randomKey);
        JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByAES), false);
        return reqSB.toString();
    }

    public static Map<String, Object> decryService(String appkey, byte[] json, byte[] randomKey, byte[] cntrKey) throws Exception {
        Map<String, Object> result = CommonSecurityService.decryService(appkey, new String(json, "UTF-8"), randomKey, cntrKey);
        return result;
    }

    public static Map<String, Object> decryService(String appkey, String json, byte[] randomKey, byte[] cntrKey) throws Exception {
        boolean dev = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String respJson = CommonSecurityService.decryString(json, randomKey, cntrKey);
        Map<String, String> resMap = JsonUtils.getMapObj(respJson);
        String headStr = resMap.get("Head");
        String dataStr = resMap.get("Data");
        Map<String, String> headMap = JsonUtils.getMapObj(headStr);
        String ircd = headMap.get("Txn_Rsp_Cd_Dsc");
        if ("000000".equals(ircd) || "OPN0100014".equals(ircd)) {
            headMap.put("Txn_Rsp_Cd_Dsc", headMap.get("SYS_RESP_CODE"));
            headMap.put("Txn_Rsp_Inf", headMap.get("SYS_RESP_DESC"));
            if ("OPN0100014".equals(ircd)) {
                dev = true;
            }
        } else if ("OPN0100003".equals(ircd)) {
            dev = true;
        }
        headMap.remove("SYS_RESP_CODE");
        headMap.remove("SYS_RESP_DESC");
        String header = JsonUtils.objToJSON(headMap);
        StringBuilder sb = new StringBuilder("{");
        JsonUtils.appendStruct(sb, "Head", header, true);
        JsonUtils.appendStruct(sb, "Data", dataStr, false);
        result.put("respValue", sb.toString());
        result.put("dev", dev);
        return result;
    }

    private static String decryString(String appkey, String respJson, byte[] randomKey, byte[] cntrKey) throws Exception {
        byte[] shaValue;
        byte[] signValueBytes;
        String sgnStr;
        boolean checkSignValue;
        if (CommonSecurityService.isTokenInval(respJson)) {
            return respJson;
        }
        Map<String, String> map = JsonUtils.getMapObj(respJson);
        String scrtData = map.get("ScrtData");
        String sgn = map.get("ScrtSgn");
        byte[] respByte = SM4Utils.decryptData_ECB(randomKey, Utils.decryptByBASE64(scrtData));
        String respMsg = new String(respByte);
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u5bc6\u540e\u7684\u54cd\u5e94\u62a5\u6587=[" + respMsg + "]");
        }
        if (!(checkSignValue = (sgnStr = Utils.encryptByBASE64(signValueBytes = SM4Utils.encryptData_ECB(cntrKey, shaValue = SM3Utils.hash(respByte)))).equals(sgn))) {
            throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
        }
        return respMsg;
    }
}

