/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.utils;

import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class FileUtils {
    private static Log log = NbczLogger.getLog(FileUtils.class);

    public static void isExist(String path) throws SDKException {
        File file = new File(path);
        if (!file.exists()) {
            throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
        }
    }

    public static String readTxtFile(String filePath) throws Exception {
        String AllTxt = "";
        try {
            InputStreamReader read;
            String encoding = "utf-8";
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    AllTxt = AllTxt + lineTxt;
                }
            } else {
                log.error("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6[" + file.getAbsolutePath() + "]");
                throw new SDKException(SDKExceptionEnums.INITIALIZE_KEYSTORE_ERROR);
            }
            read.close();
        }
        catch (Exception e) {
            if (e instanceof SDKException) {
                throw e;
            }
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519", e);
        }
        return AllTxt;
    }

    public static void copy(byte[] in, File out) throws IOException {
        FileUtils.copy(new ByteArrayInputStream(in), new BufferedOutputStream(new FileOutputStream(out)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        int res;
        try {
            res = FileUtils.copyStream(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    public static int copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        boolean var4 = true;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static void closeRandomAccessFile(RandomAccessFile ... fileArr) {
        for (int i = 0; i < fileArr.length; ++i) {
            try {
                if (fileArr[i] == null) continue;
                fileArr[i].close();
                continue;
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u5173\u95ed\u5931\u8d25", e);
            }
        }
    }
}

