/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.json;

import com.nbcb.sdk.OpenSDK;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.JsonHelperBinder;
import com.nbcb.sdk.json.JsonType;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonHelperFactory {
    private static final Log log = NbczLogger.getLog(OpenSDK.class);
    private static Map<JsonType, JsonHelperBinder> binderMap = new LinkedHashMap<JsonType, JsonHelperBinder>();
    private static List<JsonHelperBinder> binderList = new ArrayList<JsonHelperBinder>();
    private JsonHelper jsonHelper;
    private static JsonHelperFactory instance;
    private static JsonType jsonType;
    private JsonType firstJsonType;

    private JsonHelperFactory() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonHelperFactory getInstance() {
        if (instance != null) return instance;
        Class<JsonHelperFactory> clazz = JsonHelperFactory.class;
        synchronized (JsonHelperFactory.class) {
            if (instance != null) return instance;
            instance = new JsonHelperFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        JsonHelperBinder binder;
        JsonType[] values;
        for (JsonType value : values = JsonType.values()) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(value.getBinder());
                JsonHelperBinder binder2 = (JsonHelperBinder)clazz.newInstance();
                binderMap.put(value, binder2);
                binderList.add(binder2);
                if (this.firstJsonType != null) continue;
                this.firstJsonType = value;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jsonType != null) {
            binder = binderMap.get((Object)jsonType);
            if (binder == null) {
                log.error(jsonType.name() + " class not found ! ");
                throw new RuntimeException(jsonType.name() + " class not found ! ");
            }
            log.info("json lib " + jsonType.name() + " used. ");
            this.jsonHelper = binder.getJsonHelperFactory().getJsonHelper();
            return;
        }
        if (binderList.size() <= 0) {
            log.error("json lib not found ! ");
            throw new RuntimeException("json lib not found ! ");
        }
        binder = binderList.get(0);
        this.jsonHelper = binder.getJsonHelperFactory().getJsonHelper();
        log.info("json lib " + this.firstJsonType.name() + " used. ");
    }

    public static void setJsonType(JsonType jsonType) {
        JsonHelperFactory.jsonType = jsonType;
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }
}

