/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.json.BeanCopyUtil;
import com.nbcb.sdk.json.JsonHelper;
import com.nbcb.sdk.json.jackson.SDKRequestHead;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.util.List;
import java.util.Map;

public class JacksonJsonContext
implements JsonHelper {
    private static final Log log = NbczLogger.getLog(JacksonJsonContext.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public JacksonJsonContext() {
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    @Override
    public String objToJSON(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.error("json to string error", e);
            return null;
        }
    }

    @Override
    public <T> T jsonToObj(String json, Class<T> cls) throws Exception {
        return (T)this.objectMapper.readValue(json, cls);
    }

    @Override
    public Map<String, String> getMapObj(String json) throws SDKException {
        try {
            return (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json to maper obj error", e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> getMapObj(String json, Class<T> cls) {
        try {
            return (Map)this.objectMapper.readValue(json, new TypeReference<Map<String, T>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("json to maper obj error", e);
            return null;
        }
    }

    @Override
    public <T> T parseObject(String json, Class<T> cls) throws Exception {
        return (T)this.objectMapper.readValue(json, cls);
    }

    @Override
    public Map<String, Object> parseObject(String json) throws Exception {
        return this.getMapObj(json, Object.class);
    }

    @Override
    public <T> List<T> parseArray(String text, Class<T> clazz) {
        try {
            return (List)this.objectMapper.readValue(text, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("parseArray json error", e);
            return null;
        }
    }

    @Override
    public List<Map<String, String>> parseArray(String text) {
        try {
            return (List)this.objectMapper.readValue(text, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("parseArray json error", e);
            return null;
        }
    }

    @Override
    public String toJSONString(Object value) {
        try {
            if (value instanceof com.nbcb.sdk.SDKRequestHead) {
                SDKRequestHead nValue = new SDKRequestHead();
                BeanCopyUtil.copy(value, nValue);
                return this.objectMapper.writeValueAsString((Object)nValue);
            }
            return this.objectMapper.writeValueAsString(value);
        }
        catch (Exception e) {
            log.error("json to string error", e);
            return null;
        }
    }
}

