/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.log;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentHashMap;

public class LogURLClassLoader
extends URLClassLoader {
    private final ConcurrentHashMap<String, Object> parallelLockMap = new ConcurrentHashMap();
    private static final String JAVA_PACKAGE_PREFIX = "java.";
    public static final String LOGBACK_PACKAGE_PREFIX = "ch.qos.logback";
    public static final String SLF4j_PACKAGE_PREFIX = "org.slf4j";
    public static final String LOGBACKLOGGER_PACKAGE_PREFIX = "com.nbcb.sdk.log.Slf4jLogger";

    public LogURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public LogURLClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
    }

    public void addFile(File file) {
        try {
            this.addURL(file.getCanonicalFile().toURI().toURL());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            if (className.startsWith(JAVA_PACKAGE_PREFIX)) {
                return this.findSystemClass(className);
            }
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            Class<?> c = null;
            if (className.startsWith(LOGBACK_PACKAGE_PREFIX) || className.startsWith(SLF4j_PACKAGE_PREFIX) || className.startsWith(LOGBACKLOGGER_PACKAGE_PREFIX)) {
                c = this.findClass(className);
            }
            if (c != null) {
                return c;
            }
            c = this.getClazzCcl(className);
            if (c != null) {
                return c;
            }
            try {
                c = this.findSystemClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c != null) {
                return c;
            }
            throw new ClassNotFoundException(className);
        }
    }

    private Class<?> getClazzCcl(String className) {
        ClassLoader contextClassLoader = LogURLClassLoader.class.getClassLoader();
        try {
            Class<?> aClass = contextClassLoader.loadClass(className);
            return aClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        Object newLock;
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(className, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }
}

