/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.log;

import com.nbcb.sdk.log.ExceptionUtil;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.LogURLClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class NbczLogger {
    public static final String NBCB_CZ_BASEDIR = "nbcb.cz.basedir";
    public static final String NBCB_CZ_JAR_MODE = "nbcb.cz.jar.mode";
    public static final String NBCB_CZ_LOG_CONSOLE = "nbcb.cz.log.console";
    public static final String NBCB_CZ_LOG_MAXHISTORY = "nbcb.cz.log.maxhistory";
    public static final String NBCB_CZSDK = "nbcb-czsdk";
    public static final String LOGBACK_XML = "logback.xml";
    private static int maxLineLength = 20000;
    public static String LOGBACK_PATH;
    private static StringBuffer logMsg;
    private static List<String> dependentList;
    private static volatile LogURLClassLoader classLoader;

    private static void addManualJar(String jarPath) throws MalformedURLException {
        if (!jarPath.contains("!/")) {
            NbczLogger.resolveLogbackConf(new File(jarPath));
        } else {
            String userDir = NbczLogger.getBaseDir();
            NbczLogger.printMsg("nbcb-czsdk-userDir: " + userDir);
            String folderDir = userDir + File.separator + NBCB_CZSDK + File.separator + "lib";
            File folder = new File(folderDir);
            if (!folder.exists()) {
                try {
                    folder.mkdirs();
                }
                catch (Exception var11) {
                    throw new RuntimeException("mkdir failed " + folder.getPath());
                }
            }
            String logbackConfPath = new File(userDir).getPath() + File.separator + NBCB_CZSDK + File.separator + LOGBACK_XML;
            LOGBACK_PATH = new File(logbackConfPath).getAbsolutePath();
        }
        String baseDir = NbczLogger.getBaseDir();
        String libDir = baseDir + File.separator + NBCB_CZSDK + File.separator + "lib";
        File[] files = NbczLogger.filterLogbackJar(libDir);
        if (files == null || files.length != 3) {
            NbczLogger.printMsg("\u8bf7\u5728" + libDir + "\u76ee\u5f55\u4e0b\u5f15\u5165logback\u53caslf4j\u5305!");
            throw new RuntimeException("\u8bf7\u5728" + libDir + "\u76ee\u5f55\u4e0b\u5f15\u5165logback\u53caslf4j\u5305!");
        }
        for (File file : files) {
            classLoader.addFile(file);
        }
        classLoader.addFile(new File(jarPath));
    }

    private static void autoAddSearchJar(String jarPath) throws MalformedURLException {
        if (jarPath.contains("!/")) {
            NbczLogger.printMsg("\u8be5\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301spring boot \u542f\u52a8\u65b9\u5f0f!");
            throw new RuntimeException("\u8be5\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301spring boot \u542f\u52a8\u65b9\u5f0f!");
        }
        NbczLogger.resolveLogbackConf(new File(jarPath));
        String slf4jPath = NbczLogger.searchPathByClassPath("org.slf4j.LoggerFactory");
        String logbackClassicPath = NbczLogger.searchPathByClassPath("org.slf4j.impl.StaticLoggerBinder");
        String logbackCorePath = NbczLogger.searchPathByClassPath("ch.qos.logback.core.Context");
        if (slf4jPath == null || logbackClassicPath == null || logbackCorePath == null) {
            NbczLogger.printMsg("search error \u672a\u5f15\u5165logback-core \u6216 slf4j \u6216\u8005 logback-classic\u5305!!!");
            throw new RuntimeException("search error \u672a\u5f15\u5165logback-core \u6216 slf4j \u6216\u8005 logback-classic\u5305");
        }
        NbczLogger.printMsg("slf4jPath:" + slf4jPath);
        NbczLogger.printMsg("logbackClassicPath:" + logbackClassicPath);
        NbczLogger.printMsg("logbackCorePath:" + logbackCorePath);
        classLoader.addFile(new File(slf4jPath));
        classLoader.addFile(new File(logbackClassicPath));
        classLoader.addFile(new File(logbackCorePath));
        classLoader.addFile(new File(jarPath));
    }

    private static String searchPathByClassPath(String classpath) {
        ClassLoader parentClazz = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> aClass = parentClazz.loadClass(classpath);
            String path = aClass.getProtectionDomain().getCodeSource().getLocation().toURI().getSchemeSpecificPart();
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            return path;
        }
        catch (Exception e) {
            NbczLogger.printMsg("nbcb-czsdk init error \n" + ExceptionUtil.stacktraceToString(e));
            e.printStackTrace();
            return null;
        }
    }

    private static void deleteLibDir() {
        String userDir = NbczLogger.getBaseDir();
        NbczLogger.printMsg("nbcb-czsdk-userDir: " + userDir);
        File folder = new File(userDir + File.separator + NBCB_CZSDK + File.separator + "lib");
        if (folder.exists()) {
            File[] files = folder.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                file.delete();
            }
        }
    }

    private static void replaceLogHome() {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        try {
            String maxHistory;
            NbczLogger.copy(new FileInputStream(LOGBACK_PATH), arrayOutputStream);
            String logbackContent = arrayOutputStream.toString("utf-8");
            String baseDir = System.getProperty(NBCB_CZ_BASEDIR);
            if (null == baseDir || "".equals(baseDir)) {
                logbackContent = logbackContent.replace("#{LOG_HOME}", "./nbcb-czsdk/logs");
            } else {
                String logDir = NbczLogger.getBaseDir() + File.separator + NBCB_CZSDK + File.separator + "logs";
                File logDirFile = new File(logDir);
                if (!logDirFile.exists()) {
                    logDirFile.mkdirs();
                }
                logbackContent = logbackContent.replace("#{LOG_HOME}", logDirFile.toURI().getPath());
            }
            String consoleFlag = System.getProperty(NBCB_CZ_LOG_CONSOLE);
            if ("false".equals(consoleFlag)) {
                logbackContent = logbackContent.replace("<appender-ref ref=\"STDOUT\"/>", "");
            }
            logbackContent = null == (maxHistory = System.getProperty(NBCB_CZ_LOG_MAXHISTORY)) || "".equals(maxHistory) ? logbackContent.replace("#{MAX_HISTORY}", "30") : logbackContent.replace("#{MAX_HISTORY}", maxHistory);
            NbczLogger.copy(new ByteArrayInputStream(logbackContent.getBytes("utf-8")), new FileOutputStream(LOGBACK_PATH));
        }
        catch (Exception e) {
            NbczLogger.printMsg("nbcb-czsdk replaceLogHome error \n" + ExceptionUtil.stacktraceToString(e));
            e.printStackTrace();
        }
    }

    private static File[] filterLogbackJar(String dirPath) {
        File dir = new File(dirPath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String dependent : dependentList) {
                    if (!name.contains(dependent)) continue;
                    return true;
                }
                return false;
            }
        });
        return files;
    }

    public static String wrapMessage(Object message) {
        if (message == null || "".equals(message)) {
            return null;
        }
        String printMsg = message.toString();
        try {
            String subMsg = printMsg.length() > maxLineLength ? printMsg.substring(0, maxLineLength - 1) + ".." : printMsg;
            return subMsg;
        }
        catch (Exception e) {
            return message.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogURLClassLoader getLogClassLoader() {
        if (classLoader != null) return classLoader;
        Class<NbczLogger> clazz = NbczLogger.class;
        synchronized (NbczLogger.class) {
            if (classLoader != null) return classLoader;
            classLoader = new LogURLClassLoader(new URL[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Log getSlf4jogger(Class clazz) {
        Log log4JLogger = null;
        ClassLoader parentClazz = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> logClazz = classLoader.loadClass("com.nbcb.sdk.log.Slf4jLogger");
            Constructor<?> constructor = logClazz.getConstructor(String.class);
            log4JLogger = (Log)constructor.newInstance(clazz.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            NbczLogger.printMsg(" getSlfjLogger error :" + ExceptionUtil.stacktraceToString(e));
            NbczLogger.flushToLogFile();
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentClazz);
        }
        return log4JLogger;
    }

    public static Log getLog(Class clazz) {
        return NbczLogger.getSlf4jogger(clazz);
    }

    private static String getBaseDir() {
        String baseDir = System.getProperty(NBCB_CZ_BASEDIR);
        if (baseDir == null || "".equals(baseDir)) {
            return System.getProperty("user.dir");
        }
        return baseDir;
    }

    private static File resolveLogbackConf(File jarPath) throws MalformedURLException {
        String userDir = NbczLogger.getBaseDir();
        NbczLogger.printMsg("nbcb-czsdk-userDir: " + userDir);
        String folderDir = userDir + File.separator + NBCB_CZSDK + File.separator + "lib";
        File folder = new File(folderDir);
        if (!folder.exists()) {
            try {
                folder.mkdirs();
            }
            catch (Exception var11) {
                throw new RuntimeException("mkdir failed " + folder.getPath());
            }
        }
        folder.deleteOnExit();
        String logbackConfUrlStr = "jar:" + jarPath.toURI().toURL() + "!/sdklib/" + LOGBACK_XML;
        String logbackConfPath = new File(userDir).getPath() + File.separator + NBCB_CZSDK + File.separator + LOGBACK_XML;
        NbczLogger.copyFromUrlToLocal(logbackConfUrlStr, logbackConfPath);
        LOGBACK_PATH = new File(logbackConfPath).getAbsolutePath();
        return folder;
    }

    private static File resolveOpenSdkJar(File jarPath) {
        try {
            File folder = NbczLogger.resolveLogbackConf(jarPath);
            JarFile sdkJarFile = new JarFile(jarPath);
            List<JarEntry> logbackJarList = NbczLogger.filterLogbackLib(sdkJarFile);
            for (JarEntry jarEntry : logbackJarList) {
                String jarName = jarEntry.getName().replace("sdklib/", "");
                String descPath = folder.getPath() + File.separator + jarName;
                NbczLogger.copyJarEntityToLocal(sdkJarFile, jarEntry, descPath);
                classLoader.addFile(new File(descPath));
            }
            classLoader.addFile(jarPath);
            return folder;
        }
        catch (Exception var12) {
            NbczLogger.printMsg("nbcb-czsdk- unpack to folder error" + ExceptionUtil.stacktraceToString(var12));
            var12.printStackTrace();
            throw new RuntimeException(var12);
        }
    }

    private static String resolveSpringBooJar(String jarPath) {
        if (!jarPath.contains("!/")) {
            classLoader.addFile(new File(jarPath));
            return jarPath;
        }
        String userDir = NbczLogger.getBaseDir();
        NbczLogger.printMsg("nbcb-czsdk-userDir: " + userDir);
        File folder = new File(userDir + File.separator + NBCB_CZSDK + File.separator + "lib");
        if (!folder.exists()) {
            try {
                folder.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException("mkdir failed " + folder.getPath());
            }
        }
        folder.deleteOnExit();
        String[] path = jarPath.split("!/");
        String temp = path[1];
        String sdkDir = temp.substring(0, temp.lastIndexOf("/"));
        String sdkPath = temp.substring(temp.lastIndexOf("/") + 1);
        NbczLogger.printMsg("nbcb-czsdk-sdkDir=" + sdkDir);
        NbczLogger.printMsg("nbcb-czsdk-sdkPath=" + sdkPath);
        String currentJarPath = folder.getPath() + File.separator + sdkPath;
        String openSdkUrlStr = "jar:file://" + path[0] + "!/" + path[1];
        NbczLogger.copyFromUrlToLocal(openSdkUrlStr, currentJarPath);
        NbczLogger.printMsg("nbcb-czsdk-currentJarPath:" + currentJarPath);
        return currentJarPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFromUrlToLocal(String urlStr, String descPath) {
        InputStream is = null;
        try {
            URL url = new URL(urlStr);
            is = url.openStream();
            NbczLogger.copy(is, new FileOutputStream(descPath));
            NbczLogger.printMsg("url:" + urlStr + " copy to local " + descPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            NbczLogger.printMsg("nbcb-czsdk copyFromUrlToLocal error" + ExceptionUtil.stacktraceToString(e));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static List<JarEntry> filterLogbackLib(JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            for (String dependent : dependentList) {
                if (!jarEntry.getName().contains(dependent)) continue;
                list.add(jarEntry);
            }
        }
        return list;
    }

    private static void copyJarEntityToLocal(JarFile jarFile, JarEntry jarEntry, String descPath) {
        try {
            InputStream is = jarFile.getInputStream(jarEntry);
            NbczLogger.copy(is, new FileOutputStream(descPath));
            NbczLogger.printMsg("url:" + jarEntry.getName() + " copy to local " + descPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printMsg(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        System.out.println(sdf.format(new Date()) + ": " + data);
        logMsg.append(sdf.format(new Date()) + ": " + data).append("\n");
    }

    private static synchronized void flushToLogFile() {
        Writer writer = null;
        try {
            String baseDir = NbczLogger.getBaseDir();
            String logDir = baseDir + File.separator + NBCB_CZSDK + File.separator + "logs";
            if (!new File(logDir).exists()) {
                new File(logDir).mkdirs();
            }
            writer = new FileWriter(new File(logDir + File.separator + "init.log"), true);
            writer.write(logMsg.toString());
            logMsg.delete(0, logMsg.length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        int res;
        try {
            res = NbczLogger.copyStream(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    public static int copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        logMsg = new StringBuffer();
        dependentList = Arrays.asList("logback-classic", "logback-core", "slf4j-api");
        try {
            NbczLogger.printMsg("====nbcb-czsdk init start====");
            String path = NbczLogger.class.getProtectionDomain().getCodeSource().getLocation().toURI().getSchemeSpecificPart();
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            NbczLogger.printMsg("nbcb-czsdk-jarpath:" + path);
            LogURLClassLoader classLoader = NbczLogger.getLogClassLoader();
            String jarMode = System.getProperty(NBCB_CZ_JAR_MODE);
            NbczLogger.printMsg("\u8bfb\u53d6jar\u5305\u6a21\u5f0f:" + jarMode);
            if ("manual".equalsIgnoreCase(jarMode)) {
                NbczLogger.addManualJar(path);
            } else if ("auto".equalsIgnoreCase(jarMode)) {
                NbczLogger.autoAddSearchJar(path);
            } else if (path.contains(".jar")) {
                NbczLogger.deleteLibDir();
                path = NbczLogger.resolveSpringBooJar(path);
                NbczLogger.resolveOpenSdkJar(new File(path));
            } else {
                File[] files;
                String baseDir = NbczLogger.getBaseDir();
                for (File file : files = NbczLogger.filterLogbackJar(baseDir + File.separator + "lib")) {
                    classLoader.addFile(file);
                }
                classLoader.addFile(new File(path));
                LOGBACK_PATH = baseDir + "/target/classes/sdklib/logback.xml";
            }
            NbczLogger.replaceLogHome();
        }
        catch (Exception e) {
            NbczLogger.printMsg("nbcb-czsdk init error \n" + ExceptionUtil.stacktraceToString(e));
            e.printStackTrace();
        }
        finally {
            NbczLogger.printMsg("====nbcb-czsdk init end====");
            NbczLogger.flushToLogFile();
        }
    }
}

