/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.TestReport;
import com.offbytwo.jenkins.model.TestResult;
import java.io.IOException;
import org.apache.http.client.HttpResponseException;

public class Build
extends BaseModel {
    public static final Build BUILD_HAS_NEVER_RUN = new Build(-1, -1, "UNKNOWN"){

        @Override
        public TestReport getTestReport() {
            return TestReport.NO_TEST_REPORT;
        }

        @Override
        public BuildWithDetails details() {
            return BuildWithDetails.BUILD_HAS_NEVER_RUN;
        }
    };
    public static final Build BUILD_HAS_BEEN_CANCELLED = new Build(-1, -1, "CANCELLED"){

        @Override
        public TestReport getTestReport() {
            return TestReport.NO_TEST_REPORT;
        }

        @Override
        public BuildWithDetails details() {
            return BuildWithDetails.BUILD_HAS_BEEN_CANCELLED;
        }
    };
    private int number;
    private int queueId;
    private String url;

    private Build(int number, int queueId, String url) {
        this.number = number;
        this.queueId = queueId;
        this.url = url;
    }

    public Build() {
    }

    public Build(Build from) {
        this(from.getNumber(), from.getUrl());
    }

    public Build(int number, String url) {
        this.number = number;
        this.url = url;
    }

    public int getNumber() {
        return this.number;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public String getUrl() {
        return this.url;
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    protected void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    public BuildWithDetails details() throws IOException {
        return this.client.get(this.url, BuildWithDetails.class);
    }

    public TestReport getTestReport() throws IOException {
        return this.client.get(this.getUrl() + "/testReport/?depth=1", TestReport.class);
    }

    public TestResult getTestResult() throws IOException {
        return this.client.get(this.getUrl() + "/testReport/?depth=1", TestResult.class);
    }

    public String Stop() throws HttpResponseException, IOException {
        try {
            return this.client.get(this.url + "stop");
        }
        catch (IOException ex) {
            if (((HttpResponseException)((Object)ex)).getStatusCode() == 405) {
                this.stopPost();
                return "";
            }
            return "";
        }
    }

    private void stopPost() throws HttpResponseException, IOException {
        this.client.post(this.url + "stop");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Build other = (Build)obj;
        if (this.number != other.number) {
            return false;
        }
        if (this.queueId != other.queueId) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        result = 31 * result + this.queueId;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }
}

