/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleDriverConnectionFactoryAdapter
extends DriverConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleDriverConnectionFactoryAdapter.class.getCanonicalName());

    public OracleDriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionProperties) throws UniversalConnectionPoolException {
        super(driver, url, connectionProperties);
    }

    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        OracleUniversalPooledConnection pooledConnection = new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
        logger.log(Level.FINEST, "{0}, {1} returns {2}", new Object[]{connection, connectionRequestInfo, pooledConnection});
        return pooledConnection;
    }
}

