/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.backups.FailoverReactor;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceInfoHolder
implements Closeable {
    private final ConcurrentMap<String, ServiceInfo> serviceInfoMap;
    private final FailoverReactor failoverReactor;
    private final boolean pushEmptyProtection;
    private String cacheDir;

    public ServiceInfoHolder(String namespace, Properties properties) {
        this.initCacheDir(namespace);
        this.serviceInfoMap = this.isLoadCacheAtStart(properties) ? new ConcurrentHashMap<String, ServiceInfo>(DiskCache.read(this.cacheDir)) : new ConcurrentHashMap<String, ServiceInfo>(16);
        this.failoverReactor = new FailoverReactor(this, this.cacheDir);
        this.pushEmptyProtection = this.isPushEmptyProtect(properties);
    }

    private void initCacheDir(String namespace) {
        String jmSnapshotPath = System.getProperty("JM.SNAPSHOT.PATH");
        this.cacheDir = !StringUtils.isBlank((String)jmSnapshotPath) ? jmSnapshotPath + File.separator + "nacos" + File.separator + "naming" + File.separator + namespace : System.getProperty("user.home") + File.separator + "nacos" + File.separator + "naming" + File.separator + namespace;
    }

    private boolean isLoadCacheAtStart(Properties properties) {
        boolean loadCacheAtStart = false;
        if (properties != null && StringUtils.isNotEmpty((String)properties.getProperty("namingLoadCacheAtStart"))) {
            loadCacheAtStart = ConvertUtils.toBoolean((String)properties.getProperty("namingLoadCacheAtStart"));
        }
        return loadCacheAtStart;
    }

    private boolean isPushEmptyProtect(Properties properties) {
        boolean pushEmptyProtection = false;
        if (properties != null && StringUtils.isNotEmpty((String)properties.getProperty("namingPushEmptyProtection"))) {
            pushEmptyProtection = ConvertUtils.toBoolean((String)properties.getProperty("namingPushEmptyProtection"));
        }
        return pushEmptyProtection;
    }

    public Map<String, ServiceInfo> getServiceInfoMap() {
        return this.serviceInfoMap;
    }

    public ServiceInfo getServiceInfo(String serviceName, String groupName, String clusters) {
        LogUtils.NAMING_LOGGER.debug("failover-mode: " + this.failoverReactor.isFailoverSwitch());
        String groupedServiceName = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        String key = ServiceInfo.getKey((String)groupedServiceName, (String)clusters);
        if (this.failoverReactor.isFailoverSwitch()) {
            return this.failoverReactor.getService(key);
        }
        return (ServiceInfo)this.serviceInfoMap.get(key);
    }

    public ServiceInfo processServiceInfo(String json) {
        ServiceInfo serviceInfo = (ServiceInfo)JacksonUtils.toObj((String)json, ServiceInfo.class);
        serviceInfo.setJsonFromServer(json);
        return this.processServiceInfo(serviceInfo);
    }

    public ServiceInfo processServiceInfo(ServiceInfo serviceInfo) {
        String serviceKey = serviceInfo.getKey();
        if (serviceKey == null) {
            return null;
        }
        ServiceInfo oldService = (ServiceInfo)this.serviceInfoMap.get(serviceInfo.getKey());
        if (this.isEmptyOrErrorPush(serviceInfo)) {
            return oldService;
        }
        this.serviceInfoMap.put(serviceInfo.getKey(), serviceInfo);
        boolean changed = this.isChangedServiceInfo(oldService, serviceInfo);
        if (StringUtils.isBlank((String)serviceInfo.getJsonFromServer())) {
            serviceInfo.setJsonFromServer(JacksonUtils.toJson((Object)serviceInfo));
        }
        MetricsMonitor.getServiceInfoMapSizeMonitor().set((double)this.serviceInfoMap.size());
        if (changed) {
            LogUtils.NAMING_LOGGER.info("current ips:(" + serviceInfo.ipCount() + ") service: " + serviceInfo.getKey() + " -> " + JacksonUtils.toJson((Object)serviceInfo.getHosts()));
            NotifyCenter.publishEvent((Event)new InstancesChangeEvent(serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters(), serviceInfo.getHosts()));
            DiskCache.write(serviceInfo, this.cacheDir);
        }
        return serviceInfo;
    }

    private boolean isEmptyOrErrorPush(ServiceInfo serviceInfo) {
        return null == serviceInfo.getHosts() || this.pushEmptyProtection && !serviceInfo.validate();
    }

    private boolean isChangedServiceInfo(ServiceInfo oldService, ServiceInfo newService) {
        String key;
        Instance host;
        if (null == oldService) {
            LogUtils.NAMING_LOGGER.info("init new ips(" + newService.ipCount() + ") service: " + newService.getKey() + " -> " + JacksonUtils.toJson((Object)newService.getHosts()));
            return true;
        }
        if (oldService.getLastRefTime() > newService.getLastRefTime()) {
            LogUtils.NAMING_LOGGER.warn("out of date data received, old-t: " + oldService.getLastRefTime() + ", new-t: " + newService.getLastRefTime());
        }
        boolean changed = false;
        HashMap<String, Instance> oldHostMap = new HashMap<String, Instance>(oldService.getHosts().size());
        for (Object host2 : oldService.getHosts()) {
            oldHostMap.put(host2.toInetAddr(), (Instance)host2);
        }
        HashMap<String, Instance> newHostMap = new HashMap<String, Instance>(newService.getHosts().size());
        for (Instance host3 : newService.getHosts()) {
            newHostMap.put(host3.toInetAddr(), host3);
        }
        HashSet<Instance> modHosts = new HashSet<Instance>();
        HashSet<Instance> newHosts = new HashSet<Instance>();
        HashSet<Instance> remvHosts = new HashSet<Instance>();
        ArrayList newServiceHosts = new ArrayList(newHostMap.entrySet());
        for (Map.Entry entry : newServiceHosts) {
            host = (Instance)entry.getValue();
            key = (String)entry.getKey();
            if (oldHostMap.containsKey(key) && !StringUtils.equals((String)host.toString(), (String)((Instance)oldHostMap.get(key)).toString())) {
                modHosts.add(host);
                continue;
            }
            if (oldHostMap.containsKey(key)) continue;
            newHosts.add(host);
        }
        for (Map.Entry entry : oldHostMap.entrySet()) {
            host = (Instance)entry.getValue();
            key = (String)entry.getKey();
            if (newHostMap.containsKey(key) || newHostMap.containsKey(key)) continue;
            remvHosts.add(host);
        }
        if (newHosts.size() > 0) {
            changed = true;
            LogUtils.NAMING_LOGGER.info("new ips(" + newHosts.size() + ") service: " + newService.getKey() + " -> " + JacksonUtils.toJson(newHosts));
        }
        if (remvHosts.size() > 0) {
            changed = true;
            LogUtils.NAMING_LOGGER.info("removed ips(" + remvHosts.size() + ") service: " + newService.getKey() + " -> " + JacksonUtils.toJson(remvHosts));
        }
        if (modHosts.size() > 0) {
            changed = true;
            LogUtils.NAMING_LOGGER.info("modified ips(" + modHosts.size() + ") service: " + newService.getKey() + " -> " + JacksonUtils.toJson(modHosts));
        }
        return changed;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.failoverReactor.shutdown();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

