/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.hash;

public enum HashAlgorithm {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private final String algorithmName;

    private HashAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public final String getAlgorithmName() {
        return this.algorithmName;
    }

    public static HashAlgorithm fromAlgorithmName(String algorithmName) {
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            if (!algorithm.getAlgorithmName().equals(algorithmName)) continue;
            return algorithm;
        }
        throw new IllegalArgumentException("Algorithm '" + algorithmName + "' is unknown.");
    }

    public String toString() {
        return this.getAlgorithmName();
    }
}

