/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.hash;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.puresoltechnologies.commons.misc.hash.HashAlgorithm;
import java.io.Serializable;
import java.util.IllegalFormatException;
import java.util.Objects;

public class HashId
implements Serializable,
Comparable<HashId> {
    private static final long serialVersionUID = 1219606473615058203L;
    private final HashAlgorithm algorithm;
    private final String hash;
    private final int hashCode;

    public static final HashId valueOf(String hashIdString) throws IllegalFormatException {
        String[] splits = hashIdString.split(":");
        if (splits.length != 2) {
            throw new IllegalArgumentException("Could not convert string '" + hashIdString + "' into a valid hash id. There should be a colon ':' separator.");
        }
        String algorithmName = splits[0];
        String hash = splits[1];
        HashAlgorithm algorithm = HashAlgorithm.fromAlgorithmName(algorithmName);
        return new HashId(algorithm, hash);
    }

    public HashId(HashAlgorithm algorithm, String hash) {
        if (hash == null || hash.isEmpty()) {
            throw new IllegalArgumentException("hash must not be null or empty.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("The algorithm must not be null.");
        }
        this.algorithm = algorithm;
        this.hash = hash;
        this.hashCode = Objects.hash(new Object[]{algorithm, hash});
    }

    @JsonCreator
    public HashId(@JsonProperty(value="algorithm") HashAlgorithm algorithm, @JsonProperty(value="algorithmName") String algorithmName, @JsonProperty(value="hash") String hash) {
        this(algorithm, hash);
        if (!algorithmName.equals(algorithm.getAlgorithmName())) {
            throw new IllegalArgumentException("Provided algorithm name '" + algorithmName + "' does not match to the algorithm '" + algorithm.name() + "'.");
        }
    }

    public HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmName() {
        return this.algorithm.getAlgorithmName();
    }

    public String getHash() {
        return this.hash;
    }

    public final String toString() {
        return this.algorithm.getAlgorithmName() + ":" + this.hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashId other = (HashId)obj;
        if (this.algorithm != other.algorithm) {
            return false;
        }
        return !(this.hash == null ? other.hash != null : !this.hash.equals(other.hash));
    }

    @Override
    public int compareTo(HashId other) {
        return this.toString().compareTo(other.toString());
    }
}

