/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.hash;

import com.puresoltechnologies.commons.misc.hash.HashAlgorithm;
import com.puresoltechnologies.commons.misc.hash.HashId;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtilities {
    private static final HashAlgorithm DEFAULT_MESSAGE_DIGEST_ALGORITHM = HashAlgorithm.SHA256;

    public static HashAlgorithm getDefaultMessageDigestAlgorithm() {
        return DEFAULT_MESSAGE_DIGEST_ALGORITHM;
    }

    public static MessageDigest getDefaultMessageDigest() {
        try {
            return MessageDigest.getInstance(DEFAULT_MESSAGE_DIGEST_ALGORITHM.getAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Default message digest algorithm '" + DEFAULT_MESSAGE_DIGEST_ALGORITHM.getAlgorithmName() + "' is not available.");
        }
    }

    public static HashId createHashId(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            HashId hashId = HashUtilities.createHashId(stream);
            return hashId;
        }
    }

    public static HashId createHashId(String string) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(Charset.defaultCharset()));){
            HashId hashId = HashUtilities.createHashId(byteArrayInputStream);
            return hashId;
        }
    }

    private static HashId createHashId(InputStream stream) throws IOException {
        try (DigestInputStream digestInputStream = new DigestInputStream(stream, HashUtilities.getDefaultMessageDigest());){
            byte[] buffer = new byte[256];
            while (digestInputStream.read(buffer) >= 0) {
            }
            byte[] hashBytes = digestInputStream.getMessageDigest().digest();
            String hashString = HashUtilities.convertByteArrayToString(hashBytes);
            HashId hashId = new HashId(HashUtilities.getDefaultMessageDigestAlgorithm(), hashString);
            return hashId;
        }
    }

    private static String convertByteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Byte array must not be null!");
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            int digit = 0xFF & byteArray[i];
            String hexDigits = Integer.toHexString(digit);
            if (hexDigits.length() < 2) {
                hexString.append("0");
            }
            hexString.append(hexDigits);
        }
        return hexString.toString();
    }

    private HashUtilities() {
    }
}

