/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import java.math.BigInteger;

public enum BinaryPrefix {
    ONE("", ""),
    KILO("k", "Kilo"),
    MEGA("M", "Mega"),
    GIGA("G", "Giga"),
    TERA("T", "Tera"),
    PETA("P", "Peta"),
    EXA("E", "Exa"),
    ZETTA("Z", "Zetta"),
    YOTTA("Y", "Yotta");

    private final String unit;
    private final String name;
    private final BigInteger binaryFactor;
    private final BigInteger decimalFactor;

    public static BinaryPrefix getSuitablePrefix(long size) {
        if (size == 0L) {
            return ONE;
        }
        size = Math.abs(size);
        BinaryPrefix[] values = BinaryPrefix.values();
        for (int pos = 1; pos < values.length; ++pos) {
            if (values[pos].getBinaryFactor().compareTo(BigInteger.valueOf(size)) <= 0) continue;
            return values[pos - 1];
        }
        return YOTTA;
    }

    private BinaryPrefix(String unit, String name) {
        this.unit = unit;
        this.name = name;
        int powerDividedByThree = this.ordinal();
        this.binaryFactor = BigInteger.valueOf(1024L).pow(powerDividedByThree);
        this.decimalFactor = BigInteger.TEN.pow(powerDividedByThree * 3);
    }

    public String toString() {
        return this.unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getBinaryFactor() {
        return this.binaryFactor;
    }

    public BigInteger getDecimalFactor() {
        return this.decimalFactor;
    }
}

