/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FileSearch {
    public static String wildcardsToRegExp(String pattern) {
        pattern = pattern.replaceAll("\\.", "\\\\.");
        if (File.separator.equals("\\")) {
            pattern = pattern.replaceAll("\\*", "[^\\\\\\\\]*");
            pattern = pattern.replaceAll("\\?", "[^\\\\\\\\]");
        } else {
            pattern = pattern.replaceAll("\\*", "[^" + File.separator + "]*");
            pattern = pattern.replaceAll("\\?", "[^" + File.separator + "]");
        }
        return pattern;
    }

    public static List<File> find(File directory, String pattern) {
        pattern = FileSearch.wildcardsToRegExp(pattern);
        List<File> files = FileSearch.findFilesInDirectory(directory, Pattern.compile(pattern), true);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            String fileString = file.getPath().substring(directory.getPath().length());
            result.add(new File(fileString));
        }
        return result;
    }

    private static List<File> findFilesInDirectory(File directory, Pattern pattern, boolean scanRecursive) {
        ArrayList<File> files = new ArrayList<File>();
        String[] filesInDirectory = directory.list();
        if (filesInDirectory == null) {
            return files;
        }
        for (String fileToCheck : filesInDirectory) {
            File file = new File(directory, fileToCheck);
            if (file.isFile()) {
                if (!pattern.matcher(fileToCheck).matches()) continue;
                files.add(file);
                continue;
            }
            if (!file.isDirectory() || !scanRecursive) continue;
            files.addAll(FileSearch.findFilesInDirectory(file, pattern, scanRecursive));
        }
        return files;
    }
}

