/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FileSearchConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4724648711481875290L;
    private final List<String> locationIncludes = new ArrayList<String>();
    private final List<String> locationExcludes = new ArrayList<String>();
    private final List<String> fileIncludes = new ArrayList<String>();
    private final List<String> fileExcludes = new ArrayList<String>();
    private final boolean ignoreHidden;
    private final int hashCode;

    public FileSearchConfiguration() {
        this.ignoreHidden = false;
        this.hashCode = 0;
    }

    @JsonCreator
    public FileSearchConfiguration(@JsonProperty(value="locationIncludes") List<String> locationIncludes, @JsonProperty(value="locationExcludes") List<String> locationExcludes, @JsonProperty(value="fileIncludes") List<String> fileIncludes, @JsonProperty(value="fileExcludes") List<String> fileExcludes, @JsonProperty(value="ignoreHidden") boolean ignoreHidden) {
        this.fileIncludes.addAll(fileIncludes);
        this.fileExcludes.addAll(fileExcludes);
        this.locationIncludes.addAll(locationIncludes);
        this.locationExcludes.addAll(locationExcludes);
        this.ignoreHidden = ignoreHidden;
        this.hashCode = Objects.hash(locationIncludes, locationExcludes, fileIncludes, fileExcludes, ignoreHidden);
    }

    public final List<String> getLocationIncludes() {
        return this.locationIncludes;
    }

    public final List<String> getLocationExcludes() {
        return this.locationExcludes;
    }

    public final List<String> getFileIncludes() {
        return this.fileIncludes;
    }

    public final List<String> getFileExcludes() {
        return this.fileExcludes;
    }

    public final boolean isIgnoreHidden() {
        return this.ignoreHidden;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSearchConfiguration other = (FileSearchConfiguration)obj;
        if (this.locationExcludes == null ? other.locationExcludes != null : !this.locationExcludes.equals(other.locationExcludes)) {
            return false;
        }
        if (this.locationIncludes == null ? other.locationIncludes != null : !this.locationIncludes.equals(other.locationIncludes)) {
            return false;
        }
        if (this.fileExcludes == null ? other.fileExcludes != null : !this.fileExcludes.equals(other.fileExcludes)) {
            return false;
        }
        if (this.fileIncludes == null ? other.fileIncludes != null : !this.fileIncludes.equals(other.fileIncludes)) {
            return false;
        }
        return this.ignoreHidden == other.ignoreHidden;
    }

    public FileSearchConfiguration clone() {
        try {
            FileSearchConfiguration cloned = (FileSearchConfiguration)super.clone();
            this.setFinal(cloned, "ignoreHidden", this.ignoreHidden);
            this.setFinal(cloned, "locationIncludes", this.locationIncludes);
            this.setFinal(cloned, "locationExcludes", this.locationExcludes);
            this.setFinal(cloned, "fileIncludes", this.fileIncludes);
            this.setFinal(cloned, "fileExcludes", this.fileExcludes);
            return cloned;
        }
        catch (CloneNotSupportedException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void setFinal(FileSearchConfiguration cloned, String fieldName, T value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<FileSearchConfiguration> clazz = FileSearchConfiguration.class;
        Field field = clazz.getDeclaredField(fieldName);
        System.out.println(field.toString());
        field.setAccessible(true);
        field.set(cloned, value);
        field.setAccessible(false);
    }
}

