/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import com.puresoltechnologies.commons.misc.hash.HashAlgorithm;
import com.puresoltechnologies.commons.misc.hash.HashCodeGenerator;
import com.puresoltechnologies.commons.misc.hash.HashId;
import com.puresoltechnologies.commons.misc.io.BinaryPrefix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtilities {
    private static final Logger logger = LoggerFactory.getLogger(FileUtilities.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(targetFile);){
            FileUtilities.copy(in, out);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        do {
            if ((len = in.read(buffer)) <= 0) continue;
            out.write(buffer, 0, len);
        } while (len > 0);
    }

    public static boolean isUpdateRequired(File sourceFile, File targetFile) {
        return !targetFile.exists() || targetFile.lastModified() <= sourceFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(File directory, File fileName, String text) {
        try {
            File destination = new File(directory, fileName.getPath());
            File parent = destination.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                return false;
            }
            try (RandomAccessFile ra = new RandomAccessFile(destination, "rw");){
                ra.setLength(0L);
                ra.writeBytes(text);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String readFileToString(File directory, String fileName) throws IOException {
        return FileUtilities.readFileToString(new File(directory, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        byte[] buffer = new byte[1024];
        StringBuilder text = new StringBuilder();
        try (FileInputStream inStream = new FileInputStream(file);){
            int len;
            do {
                if ((len = inStream.read(buffer)) <= 0) continue;
                text.append(new String(buffer, 0, len, Charset.defaultCharset()));
            } while (len == buffer.length);
            String string = text.toString();
            return string;
        }
    }

    public static void deleteFileOrDir(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileUtilities.deleteFileOrDir(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("Could not remove '" + file + "'!");
        }
    }

    public static HashId createHashId(File file, HashAlgorithm algorithm) throws IOException {
        if (!file.isFile()) {
            throw new IOException("'" + file + "' is not a file!");
        }
        String content = FileUtilities.readFileToString(file);
        return new HashId(algorithm, HashCodeGenerator.get(algorithm, content));
    }

    public static String createHumanReadableSizeString(long size) {
        DecimalFormat format = new DecimalFormat("#.##");
        BinaryPrefix prefix = BinaryPrefix.getSuitablePrefix(size);
        double doubleSize = (double)size / prefix.getBinaryFactor().doubleValue();
        return format.format(doubleSize) + prefix.getUnit() + "B";
    }
}

