/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JARUtilities {
    public static void copyResource(URL resource, File destination) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        try (InputStream inStream = resource.openStream();){
            File parent = destination.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("Could not create target directory '" + parent + "'.");
            }
            try (FileOutputStream outStream = new FileOutputStream(destination);){
                int amount;
                byte[] buffer = new byte[1024];
                while ((amount = inStream.read(buffer)) >= 0) {
                    outStream.write(buffer, 0, amount);
                }
            }
        }
    }

    public static Properties readPropertyFile(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            Pattern pattern = Pattern.compile("\\$\\{([\\w.]+)\\}");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Matcher matcher;
                Object key = entry.getKey();
                String value = (String)entry.getValue();
                while ((matcher = pattern.matcher(value)).find()) {
                    String string = matcher.group(1);
                    String propertyValue = System.getProperty(string);
                    value = value.replaceAll("\\$\\{" + string + "\\}", propertyValue);
                }
                properties.put(key, value);
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static String readResourceFileToString(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null.");
        }
        try (InputStream inStream = url.openStream();){
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = inStream.read(buffer);
            while (length > 0) {
                byteArray.write(buffer, 0, length);
                length = inStream.read(buffer);
            }
            String string = byteArray.toString(Charset.defaultCharset().name());
            return string;
        }
    }

    private JARUtilities() {
    }
}

