/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.io;

import com.puresoltechnologies.commons.misc.io.PathResolutionException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtils {
    public static File classToRelativePackagePath(Class<?> clazz) {
        if (File.separator.equals("/")) {
            return new File(clazz.getName().replaceAll("\\.", File.separator) + ".java");
        }
        return new File(clazz.getName().replaceAll("\\.", File.separator + File.separator) + ".java");
    }

    public static String getRelativePath(String fromPath, String toPath, String pathSeparator) throws PathResolutionException {
        int commonLength;
        int commonIndex;
        if (fromPath.equals(toPath)) {
            return "";
        }
        String[] from = fromPath.split(Pattern.quote(pathSeparator), -1);
        String[] to = toPath.split(Pattern.quote(pathSeparator), 0);
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < to.length && commonIndex < from.length && to[commonIndex].equals(from[commonIndex]); ++commonIndex) {
            common.append(to[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + toPath + "' and '" + fromPath + "'");
        }
        StringBuffer relative = new StringBuffer();
        if (from.length != commonIndex) {
            int numDirsUp = from.length - commonIndex - 1;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        if ((commonLength = common.length()) < toPath.length()) {
            relative.append(toPath.substring(commonLength));
        }
        return relative.toString();
    }

    public static File normalizePath(File file) {
        boolean isAbsolute;
        if (file == null) {
            return new File("");
        }
        String normalizedFile = file.getPath();
        String quotedSeparator = Pattern.quote(File.separator);
        String replacementSeparator = File.separator.equals("/") ? File.separator : File.separator + File.separator;
        boolean bl = isAbsolute = file.isAbsolute() || normalizedFile.startsWith(File.separator);
        while (normalizedFile.contains(replacementSeparator + replacementSeparator)) {
            normalizedFile = normalizedFile.replaceAll(quotedSeparator + quotedSeparator, replacementSeparator);
        }
        Pattern pattern = Pattern.compile("([^\\." + replacementSeparator + "]+" + quotedSeparator + "\\.\\.)");
        Matcher matcher = pattern.matcher(normalizedFile);
        while (matcher.find()) {
            normalizedFile = normalizedFile.replace(matcher.group(1), "").replaceAll(quotedSeparator + quotedSeparator, replacementSeparator);
            if (!isAbsolute && normalizedFile.startsWith(File.separator)) {
                normalizedFile = normalizedFile.replaceFirst(quotedSeparator, "");
            } else if (isAbsolute && !normalizedFile.startsWith(File.separator)) {
                normalizedFile = File.separator + normalizedFile;
            }
            matcher = pattern.matcher(normalizedFile);
        }
        pattern = Pattern.compile(quotedSeparator + "\\." + quotedSeparator);
        matcher = pattern.matcher(normalizedFile);
        while (matcher.find()) {
            normalizedFile = normalizedFile.replace(matcher.group(0), replacementSeparator);
            matcher = pattern.matcher(normalizedFile);
        }
        if (normalizedFile.endsWith(File.separator + ".")) {
            normalizedFile = normalizedFile.substring(0, normalizedFile.length() - 2);
        }
        return new File(normalizedFile);
    }
}

