/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.commons.misc.progress;

import com.puresoltechnologies.commons.misc.progress.ProgressObservable;
import com.puresoltechnologies.commons.misc.progress.ProgressObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AbstractProgressObservable<Observable>
implements ProgressObservable<Observable> {
    private final List<WeakReference<ProgressObserver<Observable>>> observers = new ArrayList<WeakReference<ProgressObserver<Observable>>>();
    private boolean started = false;
    private long totalAmount;
    private final Observable observable = this;

    @Override
    public final void addObserver(ProgressObserver<Observable> observer) {
        if (this.started) {
            observer.started(this.observable, "Work is already started.", this.totalAmount);
        }
        this.observers.add(new WeakReference<ProgressObserver<Observable>>(observer));
    }

    @Override
    public final void removeObservable(ProgressObserver<Observable> observer) {
        for (WeakReference<ProgressObserver<Observable>> weakReference : this.observers) {
            ProgressObserver listener = (ProgressObserver)weakReference.get();
            if (listener != null && listener != observer) continue;
            this.observers.remove(weakReference);
        }
    }

    protected void fireStarted(String message, long totalAmount) {
        this.started = true;
        this.totalAmount = totalAmount;
        for (WeakReference<ProgressObserver<Observable>> weakReference : this.observers) {
            ProgressObserver observer = (ProgressObserver)weakReference.get();
            if (observer == null) {
                this.observers.remove(weakReference);
                continue;
            }
            observer.started(this.observable, message, totalAmount);
        }
    }

    protected void fireDone(String message, boolean successful) {
        this.started = false;
        for (WeakReference<ProgressObserver<Observable>> weakReference : this.observers) {
            ProgressObserver observer = (ProgressObserver)weakReference.get();
            if (observer == null) {
                this.observers.remove(weakReference);
                continue;
            }
            observer.done(this.observable, message, successful);
        }
    }

    protected final void fireUpdateWork(String message, long finished) {
        for (WeakReference<ProgressObserver<Observable>> weakReference : this.observers) {
            ProgressObserver observer = (ProgressObserver)weakReference.get();
            if (observer == null) {
                this.observers.remove(weakReference);
                continue;
            }
            observer.updateWork(this.observable, message, finished);
        }
    }
}

