/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.genesis.controller;

import com.puresoltechnologies.commons.misc.StopWatch;
import com.puresoltechnologies.genesis.commons.SequenceMetadata;
import com.puresoltechnologies.genesis.commons.TransformationException;
import com.puresoltechnologies.genesis.commons.TransformationMetadata;
import com.puresoltechnologies.genesis.controller.BuildInformation;
import com.puresoltechnologies.genesis.controller.InvalidSequenceException;
import com.puresoltechnologies.genesis.controller.NoTrackerFoundException;
import com.puresoltechnologies.genesis.controller.Transformators;
import com.puresoltechnologies.genesis.controller.statemodel.Migration;
import com.puresoltechnologies.genesis.controller.statemodel.MigrationModel;
import com.puresoltechnologies.genesis.controller.statemodel.MigrationState;
import com.puresoltechnologies.genesis.tracker.spi.Severity;
import com.puresoltechnologies.genesis.tracker.spi.TransformationTracker;
import com.puresoltechnologies.genesis.transformation.spi.ComponentTransformator;
import com.puresoltechnologies.genesis.transformation.spi.TransformationSequence;
import com.puresoltechnologies.genesis.transformation.spi.TransformationStep;
import com.puresoltechnologies.versioning.Version;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenesisController
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GenesisController.class);
    private static boolean migrate = false;
    private static boolean drop = false;
    private final TransformationTracker tracker;
    private final InetAddress machine;

    private static void showUsage() {
        System.out.println("Usage: <DDL.jar> (--drop | --migrate)");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            GenesisController.showUsage();
            return;
        }
        for (String arg : args) {
            if ("--drop".equals(arg)) {
                drop = true;
                continue;
            }
            if (!"--migrate".equals(arg)) continue;
            migrate = true;
        }
        if (drop) {
            GenesisController.runDropAll();
        }
        if (migrate) {
            GenesisController.runTransform();
        }
    }

    public static boolean runTransform() {
        return GenesisController.runTransform(null);
    }

    public static boolean runTransform(Version targetVersion) {
        GenesisController.printRunHeader("MIGRATE");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean success = false;
        try (GenesisController controller = new GenesisController();){
            controller.transform(targetVersion);
            success = true;
        }
        catch (TransformationException | InvalidSequenceException | NoTrackerFoundException e) {
            e.printStackTrace(System.err);
        }
        stopWatch.stop();
        GenesisController.printRunFooter(success, stopWatch);
        return success;
    }

    public static boolean runDropAll() {
        GenesisController.printRunHeader("DROP");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean success = false;
        try (GenesisController controller = new GenesisController();){
            controller.dropAll();
            success = true;
        }
        catch (TransformationException | NoTrackerFoundException e) {
            e.printStackTrace(System.err);
        }
        stopWatch.stop();
        GenesisController.printRunFooter(success, stopWatch);
        return success;
    }

    private static final void printRunHeader(String command) {
        System.out.println("==================================================");
        System.out.println("Genesis " + BuildInformation.getVersion());
        System.out.println("==================================================");
        logger.info("==> Genesis " + BuildInformation.getVersion() + " started: " + command + " requested. <==");
    }

    private static final void printRunFooter(boolean success, StopWatch stopWatch) {
        String stateString = success ? "SUCCESS" : "FAILED";
        logger.info("==> Genesis " + BuildInformation.getVersion() + " finished with " + stateString + " <==");
        System.out.println("==================================================");
        System.out.println("Genesis: " + stateString);
        System.out.println("Time:    " + stopWatch.getSeconds() + "s");
        System.out.println("==================================================");
    }

    public GenesisController() throws NoTrackerFoundException {
        Transformators.loadAll();
        this.tracker = this.loadTracker();
        this.machine = this.determineHost();
    }

    private TransformationTracker loadTracker() throws NoTrackerFoundException {
        ServiceLoader<TransformationTracker> trackerServices = ServiceLoader.load(TransformationTracker.class);
        Iterator<TransformationTracker> iterator = trackerServices.iterator();
        if (!iterator.hasNext()) {
            throw new NoTrackerFoundException("No tracker via SPI for service '" + TransformationTracker.class + "' found.");
        }
        TransformationTracker tracker = iterator.next();
        if (iterator.hasNext()) {
            System.err.println("Found another migration tracker '" + tracker.getClass().getName() + "'!");
            throw new NoTrackerFoundException("Multiple trackers via SPI for service '" + TransformationTracker.class + "' found.");
        }
        return tracker;
    }

    private InetAddress determineHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not determin hostname.", e);
        }
    }

    public InetAddress getHost() {
        return this.machine;
    }

    @Override
    public void close() {
        Transformators.unloadAll();
    }

    public void transform() throws TransformationException, InvalidSequenceException {
        this.transform(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Version targetVersion) throws TransformationException, InvalidSequenceException {
        this.tracker.open();
        try {
            ArrayList<ComponentTransformator> allTransformators = new ArrayList<ComponentTransformator>(Transformators.getAll());
            this.logInfo("The following component transformators will be run in order:");
            for (int i = 0; i < allTransformators.size(); ++i) {
                ComponentTransformator transformator = (ComponentTransformator)allTransformators.get(i);
                this.logInfo(MessageFormat.format("{0}) " + transformator.getComponentName(), i + 1));
            }
            for (ComponentTransformator transformator : allTransformators) {
                this.runTransformator(transformator, targetVersion);
            }
        }
        finally {
            this.tracker.close();
        }
    }

    private void runTransformator(ComponentTransformator transformator, Version targetVersion) throws InvalidSequenceException, TransformationException {
        this.logInfo("Starting transformator for component '" + transformator.getComponentName() + "'...");
        MigrationModel model = MigrationModel.create(transformator);
        if (targetVersion == null) {
            targetVersion = model.getMaximumVersion();
        }
        this.runTransformations(transformator.getComponentName(), model, targetVersion);
        this.logInfo("Transformator for component '" + transformator.getComponentName() + "' stopped.");
    }

    private void runTransformations(String componentName, MigrationModel model, Version targetVersion) throws TransformationException {
        TransformationMetadata lastTransformation = this.tracker.getLastTransformationMetadata(componentName, this.machine);
        this.setModelToCurrentState(model, lastTransformation);
        Migration migration = this.findNextMigration(model, targetVersion);
        while (migration != null) {
            this.runSequence(migration.getSequence());
            model.performTransition(migration);
            migration = this.findNextMigration(model, targetVersion);
        }
    }

    private Migration findNextMigration(MigrationModel model, Version targetVersion) {
        Migration migration = null;
        MigrationState currentState = (MigrationState)model.getState();
        Version nextVersion = currentState.getVersion();
        for (Migration nextMigration : currentState.getTransitions()) {
            MigrationState nextTargetState = nextMigration.getTargetState();
            Version nextTargetVersion = nextTargetState.getVersion();
            if (nextTargetVersion.compareTo(targetVersion) > 0 || nextVersion.compareTo(nextTargetVersion) >= 0) continue;
            nextVersion = nextTargetVersion;
            migration = nextMigration;
        }
        return migration;
    }

    private void setModelToCurrentState(MigrationModel model, TransformationMetadata lastTransformation) {
        if (lastTransformation == null) {
            return;
        }
        Version currentVersion = lastTransformation.getTargetVersion();
        SequenceMetadata lastSequenceMetadata = lastTransformation.getSequenceMetadata();
        for (MigrationState state : model.getVertices()) {
            if (state.getVersion().compareTo(currentVersion) >= 0) continue;
            for (Migration migration : state.getTransitions()) {
                TransformationSequence sequence = migration.getSequence();
                if (!sequence.getMetadata().equals((Object)lastSequenceMetadata)) continue;
                model.setState(state);
                return;
            }
        }
        throw new IllegalStateException("There was not state found which fit to the last transformation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSequence(TransformationSequence sequence) throws TransformationException {
        sequence.open();
        try {
            this.logInfo("Check and run sequence " + sequence);
            for (TransformationStep transformation : sequence.getTransformations()) {
                TransformationMetadata metadata = transformation.getMetadata();
                if (!this.tracker.wasMigrated(metadata.getComponentName(), this.machine, metadata.getTargetVersion(), metadata.getCommand())) {
                    this.logMigrationStart(metadata);
                    transformation.transform();
                    this.tracker.trackMigration(this.machine, metadata);
                    this.logMigrationEnd(metadata);
                    continue;
                }
                this.logMigrationSkip(metadata);
            }
        }
        finally {
            sequence.close();
        }
    }

    public void dropAll() throws TransformationException {
        this.tracker.open();
        try {
            for (ComponentTransformator transformator : Transformators.getAll()) {
                logger.info("Dropping component '" + transformator.getComponentName() + "' and its history from Genesis.");
                transformator.dropAll();
                this.tracker.dropComponentHistory(transformator.getComponentName(), this.machine);
                logger.info("done.");
            }
        }
        finally {
            this.tracker.close();
        }
    }

    private void logMigrationStart(TransformationMetadata metadata) {
        this.logInfo(metadata.getComponentName() + " " + metadata.getTargetVersion() + " by " + metadata.getDeveloper() + " (" + metadata.getComment() + "):\n\t" + metadata.getCommand());
    }

    private void logMigrationEnd(TransformationMetadata metadata) {
        this.logInfo("done.");
    }

    private void logMigrationSkip(TransformationMetadata metadata) {
        this.logInfo("(!) SKIPPED: " + metadata.getComponentName() + " " + metadata.getTargetVersion() + " by " + metadata.getDeveloper() + " (" + metadata.getComment() + ")");
    }

    private void logInfo(String message) {
        this.log(Severity.INFO, message, null);
        logger.info(message);
    }

    private void logWarning(String message) {
        this.log(Severity.WARN, message, null);
        logger.warn(message);
    }

    private void logError(String message) {
        this.log(Severity.ERROR, message, null);
        logger.error(message);
    }

    private void log(Severity severity, String message, Throwable cause) {
        this.tracker.log(new Date(), severity, this.machine, Thread.currentThread(), message, cause);
    }
}

