/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.genesis.controller.statemodel;

import com.puresoltechnologies.genesis.commons.ProvidedVersionRange;
import com.puresoltechnologies.genesis.commons.SequenceMetadata;
import com.puresoltechnologies.genesis.controller.InvalidSequenceException;
import com.puresoltechnologies.genesis.controller.statemodel.Migration;
import com.puresoltechnologies.genesis.controller.statemodel.MigrationState;
import com.puresoltechnologies.genesis.transformation.spi.ComponentTransformator;
import com.puresoltechnologies.genesis.transformation.spi.TransformationSequence;
import com.puresoltechnologies.graph.CycleAnalyzer;
import com.puresoltechnologies.graph.DeadEndAnalyzer;
import com.puresoltechnologies.graph.Graph;
import com.puresoltechnologies.graph.SubgraphAnalyzer;
import com.puresoltechnologies.graph.Vertex;
import com.puresoltechnologies.statemodel.AbstractStateModel;
import com.puresoltechnologies.statemodel.State;
import com.puresoltechnologies.versioning.Version;
import com.puresoltechnologies.versioning.VersionMath;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class MigrationModel
extends AbstractStateModel<MigrationState, Migration> {
    private static final Version VERSION_0_0_0 = new Version(0, 0, 0);
    private final MigrationState startState = new MigrationState(VERSION_0_0_0);
    private final Map<Version, MigrationState> states = new HashMap<Version, MigrationState>();
    private final Set<MigrationState> endStates = new HashSet<MigrationState>();
    private final Version maximumVersion;

    public static MigrationModel create(ComponentTransformator transformator) throws InvalidSequenceException {
        MigrationModel model = new MigrationModel(transformator);
        if (DeadEndAnalyzer.hasDeadEnds((Graph)model, (Vertex)model.getStartState(), model.getEndStates())) {
            throw new InvalidSequenceException("There are dead ends in the model which do not allow to migrate to latest version.");
        }
        if (CycleAnalyzer.hasCycles((Graph)model, (Vertex)model.getStartState(), (boolean)true)) {
            throw new InvalidSequenceException("There are cycles in the model which do not allow to migrate sequentially.");
        }
        if (SubgraphAnalyzer.hasDisconnectedSubgraph((Graph)model)) {
            throw new InvalidSequenceException("There are disconnected versions in the model which cannot be a migration target.");
        }
        return model;
    }

    private MigrationModel(ComponentTransformator transformator) throws InvalidSequenceException {
        this.states.put(VERSION_0_0_0, this.startState);
        this.setState(this.startState);
        this.maximumVersion = this.createModel(transformator);
    }

    private Version createModel(ComponentTransformator transformator) throws InvalidSequenceException {
        Version maximumVersion = this.startState.getVersion();
        for (TransformationSequence sequence : transformator.getSequences()) {
            MigrationState targetState;
            SequenceMetadata sequenceMetadata = sequence.getMetadata();
            Version startVersion = sequenceMetadata.getStartVersion();
            Version targetVersion = sequenceMetadata.getProvidedVersionRange().getMinimum();
            maximumVersion = VersionMath.max((Version[])new Version[]{maximumVersion, targetVersion});
            if (startVersion.compareTo(targetVersion) >= 0) {
                throw new InvalidSequenceException("Sequence with start version " + startVersion.toString() + " and target version " + targetVersion.toString() + " is not allowed. Down migrations are not supported.");
            }
            MigrationState startState = this.states.get(startVersion);
            if (startState == null) {
                startState = new MigrationState(startVersion);
                this.states.put(startVersion, startState);
            }
            if ((targetState = this.states.get(targetVersion)) == null) {
                targetState = new MigrationState(targetVersion);
                this.states.put(targetVersion, targetState);
            }
            startState.addMigration(targetState, sequence);
        }
        this.endStates.add(this.states.get(maximumVersion));
        return maximumVersion;
    }

    public Set<MigrationState> getVertices() {
        return new HashSet<MigrationState>(this.states.values());
    }

    public MigrationState getStartState() {
        return this.startState;
    }

    public Set<MigrationState> getEndStates() {
        return this.endStates;
    }

    public Version getMaximumVersion() {
        return this.maximumVersion;
    }

    public void setState(MigrationState state) {
        super.setState((State)state);
    }

    public void print(PrintStream stream) {
        MigrationState state = this.startState;
        this.print(stream, state, new Vector<Migration>());
    }

    public void print(PrintStream stream, MigrationState state, Vector<Migration> migrations) {
        ProvidedVersionRange providedVersionRange;
        Migration migration2;
        if (state == null) {
            return;
        }
        Version version = state.getVersion();
        Version nextVersion = null;
        for (int index = 0; index < migrations.size(); ++index) {
            migration2 = migrations.get(index);
            providedVersionRange = migration2.getSequence().getMetadata().getProvidedVersionRange();
            if (providedVersionRange.getMinimum().compareTo(version) > 0) {
                stream.print(". ");
                continue;
            }
            if (providedVersionRange.getMinimum().compareTo(version) == 0) {
                stream.print("* ");
                continue;
            }
            if (providedVersionRange.includes(version)) {
                stream.print("| ");
                nextVersion = nextVersion != null ? VersionMath.min((Version[])new Version[]{nextVersion, providedVersionRange.getMaximum()}) : providedVersionRange.getMaximum();
                continue;
            }
            if (providedVersionRange.getMaximum().compareTo(version) < 0) {
                stream.print("  ");
                continue;
            }
            if (providedVersionRange.getMaximum().compareTo(version) != 0) continue;
            stream.print("- ");
        }
        for (Migration migration2 : state.getTransitions()) {
            providedVersionRange = migration2.getSequence().getMetadata().getProvidedVersionRange();
            nextVersion = nextVersion != null ? VersionMath.min((Version[])new Version[]{nextVersion, providedVersionRange.getMinimum()}) : providedVersionRange.getMinimum();
            migrations.addElement(migration2);
            stream.print("V ");
        }
        stream.println(version.toString());
        for (int index = 0; index < migrations.size(); ++index) {
            migration2 = migrations.get(index);
            providedVersionRange = migration2.getSequence().getMetadata().getProvidedVersionRange();
            if (providedVersionRange.includes(version)) {
                stream.print("| ");
                continue;
            }
            if (providedVersionRange.getMinimum().compareTo(version) > 0) {
                stream.print(". ");
                continue;
            }
            stream.print("  ");
        }
        stream.println();
        this.print(stream, this.states.get(nextVersion), migrations);
    }
}

