/*
 * Decompiled with CFR 0.152.
 */
package com.puresoltechnologies.genesis.controller.statemodel;

import com.puresoltechnologies.genesis.controller.statemodel.Migration;
import com.puresoltechnologies.genesis.transformation.spi.TransformationSequence;
import com.puresoltechnologies.statemodel.State;
import com.puresoltechnologies.versioning.Version;
import java.util.HashSet;
import java.util.Set;

public class MigrationState
implements State<MigrationState, Migration> {
    private final Version version;
    private final Set<Migration> migrations = new HashSet<Migration>();
    private final Set<Migration> edges = new HashSet<Migration>();

    public MigrationState(Version version) {
        this.version = version;
    }

    public Set<Migration> getEdges() {
        return this.edges;
    }

    public String getName() {
        return "Version " + this.version.toString();
    }

    public Set<Migration> getTransitions() {
        return this.migrations;
    }

    public Version getVersion() {
        return this.version;
    }

    private void addEdge(Migration migration) {
        if (!this.edges.add(migration)) {
            throw new IllegalStateException("Edge '" + migration.toString() + "' was already included. " + "Duplicates are forbidden to avoid ambiguities.");
        }
    }

    public void addMigration(MigrationState targetState, TransformationSequence sequence) {
        Migration migration = new Migration(this, targetState, sequence);
        if (!this.migrations.add(migration)) {
            throw new IllegalStateException("Migration '" + migration.toString() + "' was already included. " + "Duplicates are forbidden to avoid ambiguities.");
        }
        targetState.addEdge(migration);
        this.addEdge(migration);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MigrationState other = (MigrationState)obj;
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }

    public String toString() {
        return this.getName();
    }
}

