/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.processing;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.processing.OperationStatus;
import com.qiniu.storage.Configuration;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;

public final class OperationManager {
    private final Client client;
    private final Auth auth;
    private Configuration configuration;

    public OperationManager(Auth auth, Configuration cfg) {
        this.auth = auth;
        this.configuration = cfg.clone();
        this.client = new Client(this.configuration);
    }

    public OperationManager(Auth auth, Client client) {
        this.auth = auth;
        this.client = client;
        this.configuration = new Configuration();
    }

    public OperationManager(Auth auth, Configuration cfg, Client client) {
        this.auth = auth;
        this.client = client;
        this.configuration = cfg;
    }

    public String pfop(String bucket, String key, String fops) throws QiniuException {
        return this.pfop(bucket, key, fops, null);
    }

    public String pfop(String bucket, String key, String fops, StringMap params) throws QiniuException {
        params = params == null ? new StringMap() : params;
        params.put("bucket", bucket).put("key", key).put("fops", fops);
        byte[] data = StringUtils.utf8Bytes(params.formString());
        String url = this.configuration.apiHost(this.auth.accessKey, bucket) + "/pfop/";
        StringMap headers = this.auth.authorization(url, data, "application/x-www-form-urlencoded");
        Response response = this.client.post(url, data, headers, "application/x-www-form-urlencoded");
        if (!response.isOK()) {
            throw new QiniuException(response);
        }
        PfopResult status = response.jsonToObject(PfopResult.class);
        response.close();
        if (status != null) {
            return status.persistentId;
        }
        return null;
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, boolean force) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public String pfop(String bucket, String key, String fops, String pipeline, String notifyURL, boolean force) throws QiniuException {
        StringMap params = new StringMap().putNotEmpty("pipeline", pipeline).putNotEmpty("notifyURL", notifyURL).putWhen("force", 1, force);
        return this.pfop(bucket, key, fops, params);
    }

    public OperationStatus prefop(String persistentId) throws QiniuException {
        return this.prefop(persistentId, OperationStatus.class);
    }

    public <T> T prefop(String persistentId, Class<T> retClass) throws QiniuException {
        String url = String.format("%s/status/get/prefop?id=%s", this.configuration.apiHost(), persistentId);
        Response response = this.client.get(url);
        if (!response.isOK()) {
            throw new QiniuException(response);
        }
        T object = response.jsonToObject(retClass);
        response.close();
        return object;
    }

    private class PfopResult {
        public String persistentId;

        private PfopResult() {
        }
    }
}

