/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionFileDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionMemReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auction"}, name="\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "at.auction.con";
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".saveAuction", (Object)"atAuctionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionFileStr())) {
            AtAuctionFileDomain atAuctionFileDomain = (AtAuctionFileDomain)JsonUtil.buildNormalBinder().getJsonToObject(atAuctionDomain.getAtAuctionFileStr(), AtAuctionFileDomain.class);
            atAuctionDomain.setAtAuctionFileDomain(atAuctionFileDomain);
        }
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAtAuctionMemStr())) {
            List atAuctionMemDomain = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAtAuctionMemStr(), AtAuctionMemDomain.class);
            atAuctionDomain.setAtAuctionMemDomainList(atAuctionMemDomain);
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        if (StringUtils.isNotBlank((String)atAuctionDomain.getAuctionGinfoStr())) {
            List atAuctionGinfoDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(atAuctionDomain.getAuctionGinfoStr(), AtAuctionGinfoDomain.class);
            for (AtAuctionGinfoDomain atAuctionGinfoDomain : atAuctionGinfoDomains) {
                String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
                atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
                for (String str : goodsCode) {
                    atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                    }
                    map = new HashMap<String, String>();
                    map.put("goodsCode", str);
                    map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                    map.put("unwantedRelatedData", "unwantedRelatedData");
                    RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                    try {
                        BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                    }
                    catch (Exception e) {
                        this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                    }
                    atAuctionGoodsList.add(atAuctionGoodsDomain);
                }
                this.calculation(atAuctionGinfoDomain, atAuctionGoodsList);
                atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
            }
            atAuctionDomain.setAuctionGinfoDomainList(atAuctionGinfoDomains);
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionServiceRepository.saveatAuction(atAuctionDomain);
    }

    private void calculation(AtAuctionGinfoDomain atAuctionGinfoDomain, List<AtAuctionGoodsDomain> atAuctionGoodsList) {
        if (null == atAuctionGinfoDomain || ListUtil.isNotEmpty(atAuctionGoodsList)) {
            return;
        }
        BigDecimal goodsnpirce = new BigDecimal(0);
        BigDecimal goodsweight = new BigDecimal(0);
        BigDecimal goodsprice = new BigDecimal(0);
        for (AtAuctionGoodsDomain atAuctionGoodsDomain : atAuctionGoodsList) {
            goodsprice.add(atAuctionGoodsDomain.getGoodsSupplyweight().multiply(atAuctionGoodsDomain.getPricesetNprice()));
            goodsweight.add(atAuctionGoodsDomain.getGoodsSupplyweight());
        }
        goodsnpirce.add(goodsprice.divide(goodsweight, 2));
        atAuctionGinfoDomain.setPricesetNprice(goodsnpirce);
        atAuctionGinfoDomain.setGoodsSupplyweight(goodsweight);
        atAuctionGinfoDomain.setPricesetPrefprice(goodsprice);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionRevoke.json"}, name="\u64a4\u9500")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionRevoke(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9009\u53d6\u53ea\u80fd\u4e3a\u65b0\u589e\u548c\u5df2\u53d1\u5e03\u7684\u4fe1\u606f");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteAuctionByCode.json"}, name="\u6839\u636ecode\u5220\u9664\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(this.getTenantCode(request), auctionCode);
        if (atAuctionReDomain.getDataState() != 2) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
        }
        return this.atAuctionServiceRepository.deleteatAuctionByCode(this.getTenantCode(request), auctionCode);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u89c4\u5219\u3001\u516c\u544a\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionAuctionAudit.json"}, name="\u5e73\u53f0\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAuctionAuctionAudit(String auctionId, Integer auctionAudit, Integer oldauctionAudit, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        return this.atAuctionServiceRepository.updateatAuctionFileState(Integer.valueOf(auctionId), auctionAudit, oldauctionAudit, map);
    }

    @RequestMapping(value={"queryAuctionMemPage.json"}, name="\u67e5\u8be2\u5206\u7ec4\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<AtAuctionMemReDomain> queryAuctionMemPage(HttpServletRequest request, String auctionCode) {
        if (StringUtils.isBlank((String)auctionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionServiceRepository.queryatAuctionMemPage(param);
    }

    @RequestMapping(value={"updateAcutionRelease.json"}, name="\u91cd\u65b0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean updateAcutionRelease(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPageNotice.json"}, name="\u53ea\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNotice(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"deleteAuctions.json"}, name="\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAuctions(String auctionId) {
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() != 2) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53ea\u80fd\u5728\u7ec8\u6b62\u72b6\u6001\u624d\u80fd\u5220\u9664");
            }
            this.atAuctionServiceRepository.deleteatAuction(Integer.valueOf(str));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAuctionTermination.json"}, name="\u64a4\u9500--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAuctionTermination(String auctionId) {
        AtAuctionReDomain atAuctionReDomain;
        String[] auctions;
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"auctionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String str : auctions = auctionId.split(",")) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            if (atAuctionReDomain.getDataState() == 1) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\u72b6\u6001\u624d\u80fd\u64a4\u9500");
        }
        for (String str : auctions) {
            atAuctionReDomain = this.atAuctionServiceRepository.getatAuction(Integer.valueOf(str));
            this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(str), Integer.valueOf(2), atAuctionReDomain.getDataState(), null);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAuctionGinfo.json"}, name="\u4fdd\u5b58\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAuctionGinfo(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctionGoodsDomain atAuctionGoodsDomain = null;
        ArrayList<AtAuctionGoodsDomain> atAuctionGoodsList = null;
        HashMap<String, String> map = null;
        List AtAuctionGinfoDomain2 = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, AtAuctionGinfoDomain.class);
        for (AtAuctionGinfoDomain atAuctionGinfoDomain : AtAuctionGinfoDomain2) {
            atAuctionGinfoDomain.setMemberCode(userSession.getUserPcode());
            atAuctionGinfoDomain.setMemberName(userSession.getUserName());
            atAuctionGinfoDomain.setTenantCode(this.getTenantCode(request));
            String[] goodsCode = atAuctionGinfoDomain.getAtAuctionGoodsJson().split(",");
            atAuctionGoodsList = new ArrayList<AtAuctionGoodsDomain>();
            for (String str : goodsCode) {
                atAuctionGoodsDomain = new AtAuctionGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)atAuctionGinfoDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                map = new HashMap<String, String>();
                map.put("goodsCode", str);
                map.put("tenantCode", atAuctionGinfoDomain.getTenantCode());
                map.put("unwantedRelatedData", "unwantedRelatedData");
                RsResourceGoodsReDomain resourceGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                try {
                    BeanUtils.copyAllPropertys((Object)atAuctionGoodsDomain, (Object)resourceGoods);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".saveatAuctionGinfoBatch", (Throwable)e);
                }
                atAuctionGoodsList.add(atAuctionGoodsDomain);
            }
            atAuctionGinfoDomain.setAtAuctionGoodsDomain(atAuctionGoodsList);
        }
        return this.atAuctionServiceRepository.saveatAuctionGinfoBatch(AtAuctionGinfoDomain2);
    }

    @RequestMapping(value={"getAuctionGinfo.json"}, name="\u83b7\u53d6\u5305\u88f9\u4fe1\u606f")
    @ResponseBody
    public AtAuctionGinfoReDomain getAuctionGinfo(HttpServletRequest request, String auctionGinfCode) {
        if (StringUtils.isBlank((String)auctionGinfCode)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuctionGinfoByCode(auctionGinfCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateAuctionDtRange.json"}, name="\u4fee\u6539\u5168\u573a\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionDtRange(AtAuctionDomain atAuctionDomain) {
        if (null == atAuctionDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.atAuctionServiceRepository.updateatAuction(atAuctionDomain);
    }

    @RequestMapping(value={"updateAuctionGinfoDtRange.json"}, name="\u4fee\u6539\u5305\u88f9\u4fdd\u8bc1\u91d1\u8303\u56f4")
    @ResponseBody
    public HtmlJsonReBean updateAuctionGinfoDtRange(String paramStr) {
        if (StringUtils.isNotBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List atAuctionGinfoDomains = (List)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionGinfoDomain.class);
        if (ListUtil.isNotEmpty((Collection)atAuctionGinfoDomains)) {
            for (AtAuctionGinfoDomain atAuctionGinfoDomain : atAuctionGinfoDomains) {
                this.atAuctionServiceRepository.updateatAuctionGinfo(atAuctionGinfoDomain);
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateAcutionReleases.json"}, name="\u91cd\u65b0\u53d1\u5e03--\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateAcutionReleases(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionId is null");
        }
        return this.atAuctionServiceRepository.updateatAuctionState(Integer.valueOf(auctionId), Integer.valueOf(0), Integer.valueOf(2), null);
    }

    @RequestMapping(value={"queryAuctionPagePC.json"}, name="\u67e5\u8be2\u516c\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPagePC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "01");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"queryAuctionPageNoticePc.json"}, name="\u67e5\u8be2\u9884\u544a\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionReDomain> queryAuctionPageNoticePc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("auctionType", "00");
        }
        return this.atAuctionServiceRepository.queryatAuctionPage(param);
    }

    @RequestMapping(value={"getAuctionPC.json"}, name="\u83b7\u53d6\u516c\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionPC(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }

    @RequestMapping(value={"getAuctionNoticePc.json"}, name="\u83b7\u53d6\u9884\u544a\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public AtAuctionReDomain getAuctionNoticePc(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"auctionId is null");
            return null;
        }
        return this.atAuctionServiceRepository.getatAuction(auctionId);
    }
}

