/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionEnrollReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctiondtReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctiondtServiceRepository;
import com.qjsoft.laser.controller.facade.ta.domain.TaTransferaDomain;
import com.qjsoft.laser.controller.facade.ta.domain.TaTransferaListDomain;
import com.qjsoft.laser.controller.facade.ta.repository.TaTransferaServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountOuterSubsetDomain;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionEnroll"}, name="\u7ade\u4ef7\u62a5\u540d")
public class AuctionEnrollCon
extends SpringmvcController {
    private static String CODE = "at.auctionEnroll.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private AtAuctionEnrollServiceRepository atAuctionEnrollServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;
    @Autowired
    private AtAuctiondtServiceRepository atAuctiondtServiceRepository;
    @Autowired
    private TaTransferaServiceRepository taTransferaServiceRepository;

    protected String getContext() {
        return "auctionEnroll";
    }

    @RequestMapping(value={"saveAuctionEnroll.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getMerberCompname();
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"getAuctionEnroll.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u62a5\u540d\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".getAuctionEnroll", (Object)"param is null");
            return null;
        }
        return this.atAuctionEnrollServiceRepository.getatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"updateAuctionEnroll.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnroll(HttpServletRequest request, AtAuctionEnrollDomain atAuctionEnrollDomain) {
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".updateAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionEnrollDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"deleteAuctionEnroll.json"}, name="\u5220\u9664\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnroll(Integer auctionEnrollfileId) {
        if (StringUtils.isBlank((Integer)auctionEnrollfileId)) {
            this.logger.error(CODE + ".deleteAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.deleteatAuctionEnroll(auctionEnrollfileId);
    }

    @RequestMapping(value={"queryAuctionEnrollPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u62a5\u540d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollState(String auctionEnrollfileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionEnrollServiceRepository.updateatAuctionEnrollState(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryAuctionEnrollForAt.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryAuctionBiddingEnrollForAt.json"}, name="\u7ade\u4ef7\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionBiddingEnrollForAt(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"saveAuctionEnrollByStr.json"}, name="\u589e\u52a0\u7ade\u4ef7\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean saveAuctionEnroll(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        AtAuctionEnrollDomain atAuctionEnrollDomain = (AtAuctionEnrollDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, AtAuctionEnrollDomain.class);
        if (null == atAuctionEnrollDomain) {
            this.logger.error(CODE + ".saveAuctionEnroll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        String memberBcode = userSession.getUserPcode();
        String memberBname = userSession.getUserName();
        atAuctionEnrollDomain.setTenantCode(tenantCode);
        atAuctionEnrollDomain.setMemberBcode(memberBcode);
        atAuctionEnrollDomain.setMemberBname(memberBname);
        return this.atAuctionEnrollServiceRepository.saveatAuctionEnroll(atAuctionEnrollDomain);
    }

    @RequestMapping(value={"queryAuctionEnrollForPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u5e73\u53f0\u62a5\u540d\u5ba1\u6838")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "0");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditQstate.json"}, name="\u5ba1\u6838\u8d44\u8d28")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditQstate(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctionEnrollServiceRepository.updateAuctionEnrollAuditQstate(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateByTrans.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateByTrans(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState, String auctionAuremark, String auctionDtId, String phone) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        AtAuctiondtReDomain auctiondt = this.atAuctiondtServiceRepository.getAuctiondt(Integer.valueOf(auctionDtId));
        HtmlJsonReBean memVd = this.getMemVd(request, auctiondt.getMemberBcode(), auctiondt.getTenantCode(), auctiondt, phone);
        if (null == memVd || !memVd.isSuccess()) {
            return memVd;
        }
        TaTransferaDomain taTransferaDomain = (TaTransferaDomain)memVd.getDataObj();
        HtmlJsonReBean htmlJsonReBeans = this.taTransferaServiceRepository.saveTransferaOne(taTransferaDomain);
        if (null == htmlJsonReBeans || !htmlJsonReBeans.isSuccess()) {
            return htmlJsonReBeans;
        }
        String transferaCode = (String)htmlJsonReBeans.getDataObj();
        String tenantCode = this.getTenantCode(request);
        if (null == htmlJsonReBeans || !htmlJsonReBeans.isSuccess()) {
            return htmlJsonReBeans;
        }
        htmlJsonReBeans = this.taTransferaServiceRepository.sendTransferaMsg(transferaCode, tenantCode);
        if (null == htmlJsonReBeans || !htmlJsonReBeans.isSuccess()) {
            return htmlJsonReBeans;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionAuremark", auctionAuremark);
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        return this.atAuctiondtServiceRepository.updateAuctiondtState(Integer.valueOf(auctionDtId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateAuctionEnrollAuditDstateToFail.json"}, name="\u5ba1\u6838\u4fdd\u8bc1\u91d1\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateAuctionEnrollAuditDstateToFail(HttpServletRequest request, String auctionEnrollfileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionEnrollfileId)) {
            this.logger.error(CODE + ".updateAuctionEnrollState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        return this.atAuctiondtServiceRepository.updateAuctiondtState(Integer.valueOf(auctionEnrollfileId), dataState, oldDataState, null);
    }

    private HtmlJsonReBean getMemVd(HttpServletRequest request, String memberCode, String tenantCode, AtAuctiondtReDomain auctiondt, String phone) {
        if (null == memberCode) {
            return null;
        }
        String type = memberCode.substring(0, 1);
        String basic = "101";
        String frozen = "102";
        if ("2".equals(type)) {
            basic = "201";
            frozen = "202";
        }
        Boolean flag = false;
        Map<String, VdFaccountInfo> vd = this.getVd(memberCode, tenantCode, null);
        VdFaccountInfo vdFaccountInfobasic = vd.get(basic);
        VdFaccountInfo vdFaccountInfofrozen = vd.get(frozen);
        if (ListUtil.isEmpty((Collection)vdFaccountInfobasic.getSubsetList()) || ListUtil.isEmpty((Collection)vdFaccountInfofrozen.getSubsetList())) {
            return null;
        }
        for (VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain : vdFaccountInfobasic.getSubsetList()) {
            if (!"01".equals(vdFaccountOuterSubsetDomain.getFundType()) || vdFaccountOuterSubsetDomain.getFaccountAmount().compareTo(auctiondt.getAuctionDtDpnum()) == -1) continue;
            flag = true;
        }
        HtmlJsonReBean htmlJsonReBean = null;
        if (flag.booleanValue()) {
            TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
            taTransferaDomain.setUserinfoCode(memberCode);
            taTransferaDomain.setFaccountId(vdFaccountInfobasic.getFaccountOuterNo());
            taTransferaDomain.setTransferaOpcode(auctiondt.getAuctionDtCode());
            taTransferaDomain.setTransferaUcode(this.getUserSession(request).getUserPcode());
            taTransferaDomain.setTransferaUname(this.getUserSession(request).getUserName());
            taTransferaDomain.setTransferaName("\u4fdd\u8bc1\u91d1\u51bb\u7ed3");
            taTransferaDomain.setTransferaMoney(auctiondt.getAuctionDtDpnum());
            ArrayList<TaTransferaListDomain> taTransferaListDomains = new ArrayList<TaTransferaListDomain>();
            TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
            taTransferaListDomain.setPhone(phone);
            taTransferaListDomain.setTransferaListMoney(auctiondt.getAuctionDtDpnum());
            taTransferaListDomain.setTransferaListUno(vdFaccountInfofrozen.getFaccountOuterNo());
            taTransferaListDomain.setFaccountId(vdFaccountInfobasic.getFaccountOuterNo());
            taTransferaListDomain.setFundType(vdFaccountInfobasic.getFundType());
            taTransferaListDomain.setTransferaListUcode(memberCode);
            taTransferaListDomain.setTransferaListUname(auctiondt.getMemberBname());
            taTransferaListDomain.setTransferaListFtype(vdFaccountInfofrozen.getFundType());
            taTransferaListDomain.setTransferaListRemark("\u4fdd\u8bc1\u91d1\u51bb\u7ed3");
            taTransferaListDomain.setUserinfoCode(memberCode);
            taTransferaListDomain.setUserinfoName(auctiondt.getMemberBname());
            taTransferaListDomains.add(taTransferaListDomain);
            taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomains);
            htmlJsonReBean = this.save(request, taTransferaDomain, "11", "01", "1");
        }
        return htmlJsonReBean;
    }

    private Map<String, VdFaccountInfo> getVd(String memberCode, String tenantCode, String faccountType) {
        List vdList = this.vdFaccountServiceRepository.queryOuterFaccount(memberCode, faccountType, tenantCode);
        HashMap<String, VdFaccountInfo> account = new HashMap<String, VdFaccountInfo>();
        if (null != vdList && !vdList.isEmpty()) {
            for (VdFaccountInfo v : vdList) {
                account.put(v.getFaccountType(), v);
            }
        }
        return account;
    }

    private HtmlJsonReBean save(HttpServletRequest request, TaTransferaDomain taTransferaDomain, String transferaType, String fundType, String transferaMode) {
        List vdList;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveTransfera", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == taTransferaDomain) {
            this.logger.error(CODE + ".saveTransfera", (Object)"taTransferaDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isEmpty((String)taTransferaDomain.getUserinfoCode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u8d26\u6237userinfoCode\u4e3a\u7a7a");
        }
        String userinfoCode = taTransferaDomain.getUserinfoCode();
        String type = userinfoCode.substring(0, 1);
        String faccountType = "1" + fundType;
        if ("2".equals(type)) {
            faccountType = "2" + fundType;
        }
        if (null == (vdList = this.vdFaccountServiceRepository.queryOuterFaccount(userinfoCode, faccountType, taTransferaDomain.getTenantCode())) || vdList.isEmpty()) {
            this.logger.error(CODE + ".saveTransfera.FaccountOuterlist", (Object)"FaccountOuterlist is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u8d26\u6237\u4e3a\u7a7a");
        }
        VdFaccountInfo vdFaccountInfo = (VdFaccountInfo)vdList.get(0);
        if (null == vdFaccountInfo.getFaccountAmount()) {
            vdFaccountInfo.setFaccountAmount(BigDecimal.ZERO);
        }
        if (null == taTransferaDomain.getTransferaMoney()) {
            taTransferaDomain.setTransferaMoney(BigDecimal.ZERO);
        }
        if (vdFaccountInfo.getFaccountAmount().compareTo(taTransferaDomain.getTransferaMoney()) == -1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f59\u989d\u4e0d\u8db3");
        }
        List taTransferaListDomainList = taTransferaDomain.getTaTransferaListDomainList();
        if (null == taTransferaListDomainList || taTransferaListDomainList.size() == 0) {
            this.logger.error(CODE + ".saveTransfera.taTransferaListDomainList", (Object)"taTransferaListDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f6c\u8d26\u6d3e\u53d1\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)taTransferaDomain.getUserinfoName())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(taTransferaDomain.getUserinfoCode(), taTransferaDomain.getTenantCode());
            if (null == umUserinfoReDomainBean) {
                this.logger.error(CODE + ".saveTransfera.userlist", (Object)"userlist is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f" + taTransferaDomain.getUserinfoCode() + "\u4e3a\u7a7a");
            }
            taTransferaDomain.setUserinfoName(umUserinfoReDomainBean.getUserinfoCompname());
        }
        taTransferaDomain.setTransferaCategory(taTransferaDomain.getUserinfoCode().substring(0, 1));
        taTransferaDomain.setTenantCode(this.getTenantCode(request));
        taTransferaDomain.setUserCode(userSession.getUserCode());
        if (StringUtils.isBlank((String)taTransferaDomain.getUserName())) {
            taTransferaDomain.setUserName(userSession.getUserName());
        }
        taTransferaDomain.setTransferaType(transferaType);
        if (StringUtils.isBlank((String)transferaMode)) {
            transferaMode = "1";
        }
        taTransferaDomain.setTransferaMode(transferaMode);
        taTransferaDomain.setFchannelPmodeCode(this.getOauthEnvCode(request));
        taTransferaDomain.setAppmanageIcode(this.getProappCode(request));
        taTransferaDomain.setFundType(fundType);
        HashMap<String, String> param1 = new HashMap<String, String>();
        for (TaTransferaListDomain taTransferaListDomain : taTransferaListDomainList) {
            String phone = taTransferaListDomain.getPhone();
            userinfoCode = taTransferaListDomain.getTransferaListUcode();
            taTransferaListDomain.setTransferaListCategory(type);
            if (StringUtils.isNotBlank((String)phone) && StringUtils.isBlank((String)userinfoCode)) {
                param1.put("userPhone", phone);
                param1.put("tenantCode", taTransferaDomain.getTenantCode());
                SupQueryResult umUserReDomainBeanSupQueryResult = this.userServiceRepository.queryUserPage(param1);
                if (null == umUserReDomainBeanSupQueryResult || null == umUserReDomainBeanSupQueryResult.getList() || umUserReDomainBeanSupQueryResult.getList().isEmpty()) {
                    this.logger.error(CODE + ".saveTransfera.userlist", (Object)"userlist is null");
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f" + phone + "\u4e3a\u7a7a");
                }
            } else {
                UmUserinfoReDomainBean userinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(userinfoCode, taTransferaDomain.getTenantCode());
                if (null == userinfoReDomainBean) {
                    this.logger.error(CODE + ".saveTransfera.userinfoReDomainBean", (Object)(userinfoCode + "," + taTransferaDomain.getTenantCode()));
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f" + userinfoCode + "\u4e3a\u7a7a1");
                }
            }
            type = userinfoCode.substring(0, 1);
            faccountType = "1" + fundType;
            if ("2".equals(type)) {
                faccountType = "2" + fundType;
            }
            if (null != (vdList = this.vdFaccountServiceRepository.queryOuterFaccount(userinfoCode, faccountType, taTransferaDomain.getTenantCode())) && !vdList.isEmpty()) continue;
            this.logger.error(CODE + ".saveTransfera.FaccountOuterlist", (Object)"FaccountOuterlist is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u8d26\u6237\u4e3a\u7a7a");
        }
        return new HtmlJsonReBean((Object)taTransferaDomain);
    }

    @RequestMapping(value={"getAuctionEnrollForPaasAt.json"}, name="\u7ade\u4ef7\u5ba1\u6838\u9875\u9762")
    @ResponseBody
    public AtAuctionEnrollReDomain getAuctionEnrollForPaasAt(String auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(Integer.valueOf(auctionEnrollId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auctionCode", atAuctionEnrollReDomain.getAuctionCode());
        map.put("memberCode", atAuctionEnrollReDomain.getMemberBcode());
        map.put("tenantCode", atAuctionEnrollReDomain.getTenantCode());
        List list = this.atAuctiondtServiceRepository.queryAuctiondtPage(map).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        AtAuctiondtReDomain atAuctiondtReDomain = (AtAuctiondtReDomain)list.get(0);
        atAuctionEnrollReDomain.setAtAuctiondtReDomain(atAuctiondtReDomain);
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForAtPaas.json"}, name="\u770b\u8d27\u62a5\u540d\u5206\u9875\u5217\u8868-\u516c\u544a\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForAtPaas(HttpServletRequest request, String auctionCode) {
        if (null == auctionCode) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionCode", auctionCode);
        param.put("auctionType", "01");
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }

    @RequestMapping(value={"checkEnrollAndDt.json"}, name="\u68c0\u67e5\u662f\u5426\u62a5\u540d")
    @ResponseBody
    public HtmlJsonReBean checkEnrollAndDt(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        boolean checkEnroll = false;
        boolean checkDt = false;
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            checkEnroll = true;
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            checkDt = true;
        }
        return new HtmlJsonReBean((Object)("checkEnroll:" + checkEnroll + "," + "checkDt:" + checkDt));
    }

    @RequestMapping(value={"getEnrollTypeAndDt.json"}, name="\u83b7\u53d6\u7528\u6237\u62a5\u540dcheck\u4fe1\u606f")
    @ResponseBody
    public AtAuctionEnrollReDomain checkEnrollTypeAndDt(HttpServletRequest request, String auctionCode, String auctionEnrollType) {
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("auctionEnrollType", auctionEnrollType);
        AtAuctionEnrollReDomain atAuctionEnrollReDomain = new AtAuctionEnrollReDomain();
        atAuctionEnrollReDomain.setCheckDt(false);
        atAuctionEnrollReDomain.setCheckEnroll(false);
        SupQueryResult atAuctionEnrollResult = this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(map);
        SupQueryResult atAuctiondtResult = this.atAuctiondtServiceRepository.queryAuctiondtPage(map);
        if (ListUtil.isNotEmpty((Collection)atAuctionEnrollResult.getList())) {
            atAuctionEnrollReDomain = this.atAuctionEnrollServiceRepository.getatAuctionEnroll(((AtAuctionEnrollReDomain)atAuctionEnrollResult.getList().get(0)).getAuctionEnrollId());
            atAuctionEnrollReDomain.setCheckEnroll(true);
        }
        if (ListUtil.isNotEmpty((Collection)atAuctiondtResult.getList())) {
            atAuctionEnrollReDomain.setCheckDt(true);
        }
        return atAuctionEnrollReDomain;
    }

    @RequestMapping(value={"queryAuctionEnrollForPaasAt.json"}, name="\u5e73\u53f0\u62a5\u540d\u5ba1\u6838\u5217\u8868\u9875\u9762")
    @ResponseBody
    public SupQueryResult<AtAuctionEnrollReDomain> queryAuctionEnrollForPaasAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("auctionType", "01");
        param.put("auctionEnrollType", "1");
        param.put("tenantCode", this.getTenantCode(request));
        return this.atAuctionEnrollServiceRepository.queryatAuctionEnrollPage(param);
    }
}

