/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.at.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionGinfoReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionReDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionWinDomain;
import com.qjsoft.laser.controller.facade.at.domain.AtAuctionWinReDomain;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionServiceRepository;
import com.qjsoft.laser.controller.facade.at.repository.AtAuctionWinServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/at/auctionWin"}, name="\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
public class AuctionWinCon
extends SpringmvcController {
    private static String CODE = "at.auctionWin.con";
    @Autowired
    private AtAuctionWinServiceRepository atAuctionWinServiceRepository;
    @Autowired
    private AtAuctionServiceRepository atAuctionServiceRepository;

    protected String getContext() {
        return "auctionWin";
    }

    @RequestMapping(value={"saveAuctionWin.json"}, name="\u589e\u52a0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean saveAuctionWin(HttpServletRequest request, AtAuctionWinDomain atAuctionWinDomain) {
        if (null == atAuctionWinDomain) {
            this.logger.error(CODE + ".saveAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionWinDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionWinServiceRepository.saveatAuctionWin(atAuctionWinDomain);
    }

    @RequestMapping(value={"getAuctionWin.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u4fe1\u606f")
    @ResponseBody
    public AtAuctionWinReDomain getAuctionWin(Integer auctionWinId) {
        if (StringUtils.isBlank((Integer)auctionWinId)) {
            this.logger.error(CODE + ".getAuctionWin", (Object)"param is null");
            return null;
        }
        return this.atAuctionWinServiceRepository.getatAuctionWin(auctionWinId);
    }

    @RequestMapping(value={"updateAuctionWin.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean updateAuctionWin(HttpServletRequest request, AtAuctionWinDomain atAuctionWinDomain) {
        if (null == atAuctionWinDomain) {
            this.logger.error(CODE + ".updateAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        atAuctionWinDomain.setTenantCode(this.getTenantCode(request));
        return this.atAuctionWinServiceRepository.updateatAuctionWin(atAuctionWinDomain);
    }

    @RequestMapping(value={"deleteAuctionWin.json"}, name="\u5220\u9664\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionWin(Integer auctionWinId) {
        if (StringUtils.isBlank((Integer)auctionWinId)) {
            this.logger.error(CODE + ".deleteAuctionWin", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionWinServiceRepository.deleteatAuctionWin(auctionWinId);
    }

    @RequestMapping(value={"queryAuctionWinPage.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<AtAuctionWinReDomain> queryAuctionWinPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.atAuctionWinServiceRepository.queryatAuctionWinPage(param);
    }

    @RequestMapping(value={"updateAuctionWinState.json"}, name="\u66f4\u65b0\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionWinState(String auctionWinId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionWinId)) {
            this.logger.error(CODE + ".updateAuctionWinState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.atAuctionWinServiceRepository.updateatAuctionWinState(Integer.valueOf(auctionWinId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getAuctionWinByCode.json"}, name="\u83b7\u53d6\u7ade\u4ef7\u4e2d\u6807\u7ed3\u679c\u901a\u77e5\u4e66\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getAuctionWinByCode(HttpServletRequest request, String auctionCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        if (StringUtils.isBlank((String)auctionCode)) {
            this.logger.error(CODE + ".getAuctionWin", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        AtAuctionReDomain atAuctionReDomain = this.atAuctionServiceRepository.getatAuctionByCode(tenantCode, auctionCode);
        if (null == atAuctionReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u573a\u6b21\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map map = this.assemMapParam(request);
        map.put("auctionCode", auctionCode);
        map.put("memberBcode", userSession.getUserPcode());
        map.put("order", true);
        SupQueryResult atAuctionWinResult = this.atAuctionWinServiceRepository.queryatAuctionWinPage(map);
        if (ListUtil.isEmpty((Collection)atAuctionWinResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6682\u65e0\u4e2d\u6807\u4fe1\u606f");
        }
        AtAuctionWinReDomain atAuctionWinReDomain = (AtAuctionWinReDomain)atAuctionWinResult.getList().get(0);
        ArrayList<AtAuctionGinfoReDomain> atAuctionGinfoReDomainList = new ArrayList<AtAuctionGinfoReDomain>();
        for (AtAuctionWinReDomain atAuctionWinReDomain1 : atAuctionWinResult.getList()) {
            AtAuctionGinfoReDomain atAuctionGinfoReDomain = this.atAuctionServiceRepository.getatAuctionGinfoByCode(tenantCode, atAuctionWinReDomain1.getAuctionGinfoCode());
            atAuctionGinfoReDomainList.add(atAuctionGinfoReDomain);
        }
        atAuctionWinReDomain.setAtAuctionGinfoReDomainList(atAuctionGinfoReDomainList);
        atAuctionWinReDomain.setMemberContact(atAuctionReDomain.getMemberContact());
        atAuctionWinReDomain.setMemberContactPhone(atAuctionReDomain.getMemberContactPhone());
        atAuctionWinReDomain.setWarehouseName(atAuctionReDomain.getWarehouseName());
        atAuctionWinReDomain.setWarehouseCode(atAuctionReDomain.getWarehouseCode());
        return new HtmlJsonReBean((Object)atAuctionWinReDomain);
    }
}

