/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.bindex.controller;

import com.qjsoft.laser.controller.bindex.bean.BIndexBean;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.um.repository.UmCollectServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmFootprintServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/bi/bindex"}, name="\u4e70\u5bb6\u9996\u9875")
public class BindexCon
extends SpringmvcController {
    private static String CODE = "mi.bindex.con";
    @Autowired
    private UmCollectServiceRepository umCollectServiceRepository;
    @Autowired
    private UmFootprintServiceRepository umFootprintServiceRepository;

    protected String getContext() {
        return "bindex";
    }

    @RequestMapping(value={"index.json"}, name="\u83b7\u53d6\u4e70\u5bb6\u9996\u9875\u4fe1\u606f")
    @ResponseBody
    public BIndexBean index(HttpServletRequest request) {
        BIndexBean indexBean = new BIndexBean();
        UserInfo userInfo = this.getUserInfo(request);
        indexBean.setUserInfo(userInfo);
        HashMap<String, String> map = new HashMap<String, String>();
        indexBean.setInfoMap(map);
        map.put("goods", String.valueOf(this.getGoodsCollect(request)));
        map.put("shope", String.valueOf(this.getShopeCollect(request)));
        map.put("footprint", String.valueOf(this.getFootprint(request)));
        return indexBean;
    }

    private long getFootprint(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getFootprint", (Object)"UserSession is null");
            return 0L;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("userinfoCode", userSession.getUserPcode());
        SupQueryResult qlist = this.umFootprintServiceRepository.queryFootprintPage(param);
        if (null == qlist || null == qlist.getPageTools()) {
            return 0L;
        }
        return qlist.getTotal();
    }

    private long getGoodsCollect(HttpServletRequest request) {
        return this.getCollect(request, "0");
    }

    private long getShopeCollect(HttpServletRequest request) {
        return this.getCollect(request, "1");
    }

    private long getCollect(HttpServletRequest request, String collectType) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getGoodsCollect", (Object)"UserSession is null");
            return 0L;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("collectType", collectType);
        param.put("userinfoCode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(param);
        if (null == qlist || null == qlist.getPageTools()) {
            return 0L;
        }
        return qlist.getTotal();
    }
}

