/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.cp.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cp.domain.CpWithdrawDomain;
import com.qjsoft.laser.controller.facade.cp.domain.CpWithdrawReDomain;
import com.qjsoft.laser.controller.facade.cp.repository.CpWithdrawServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cp/withdraw"}, name="\u63d0\u73b0\u670d\u52a1")
public class WithdrawCon
extends SpringmvcController {
    private static String CODE = "cp.withdraw.con";
    @Autowired
    private CpWithdrawServiceRepository cpWithdrawServiceRepository;

    protected String getContext() {
        return "withdraw";
    }

    @RequestMapping(value={"saveWithdraw.json"}, name="\u589e\u52a0\u63d0\u73b0\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveWithdraw(HttpServletRequest request, CpWithdrawDomain cpWithdrawDomain) {
        if (null == cpWithdrawDomain) {
            this.logger.error(CODE + ".saveWithdraw", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpWithdrawDomain.setTenantCode(this.getTenantCode(request));
        return this.cpWithdrawServiceRepository.saveWithdraw(cpWithdrawDomain);
    }

    @RequestMapping(value={"saveWithdrawToPte.json"}, name="\u4e00\u6b65\u63d0\u73b0\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveWithdrawToPte(HttpServletRequest request, CpWithdrawDomain cpWithdrawDomain) {
        if (null == cpWithdrawDomain) {
            this.logger.error(CODE + ".saveWithdraw", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveModleWithdraw(request, cpWithdrawDomain, "02");
    }

    private HtmlJsonReBean saveModleWithdraw(HttpServletRequest request, CpWithdrawDomain cpWithdrawDomain, String withdrawType) {
        UserSession userSession = this.getUserSession(request);
        cpWithdrawDomain.setUserCode(userSession.getUserPcode());
        cpWithdrawDomain.setUserName(userSession.getMerberCompname());
        cpWithdrawDomain.setAppmanageIcode(this.getProappCode(request));
        cpWithdrawDomain.setPartnerCode(userSession.getUserPcode());
        cpWithdrawDomain.setWithdrawCategory(userSession.getUserPcode().substring(0, 1));
        cpWithdrawDomain.setWithdrawMode("0");
        if (StringUtils.isBlank((String)cpWithdrawDomain.getWithdrawType())) {
            cpWithdrawDomain.setWithdrawType(withdrawType);
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFchannelPmodeCode())) {
            cpWithdrawDomain.setFchannelPmodeCode(this.getOauthEnvCode(request));
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFundType())) {
            cpWithdrawDomain.setFundType("01");
        }
        cpWithdrawDomain.setTenantCode(this.getTenantCode(request));
        return this.cpWithdrawServiceRepository.saveWithdraw(cpWithdrawDomain);
    }

    @RequestMapping(value={"getWithdraw.json"}, name="\u83b7\u53d6\u63d0\u73b0\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public CpWithdrawReDomain getWithdraw(Integer withdrawId) {
        if (StringUtils.isBlank((Integer)withdrawId)) {
            this.logger.error(CODE + ".getWithdraw", (Object)"param is null");
            return null;
        }
        return this.cpWithdrawServiceRepository.getWithdraw(withdrawId);
    }

    @RequestMapping(value={"updateWithdraw.json"}, name="\u66f4\u65b0\u63d0\u73b0\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateWithdraw(HttpServletRequest request, CpWithdrawDomain cpWithdrawDomain) {
        if (null == cpWithdrawDomain) {
            this.logger.error(CODE + ".updateWithdraw", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cpWithdrawDomain.setTenantCode(this.getTenantCode(request));
        return this.cpWithdrawServiceRepository.updateWithdraw(cpWithdrawDomain);
    }

    @RequestMapping(value={"deleteWithdraw.json"}, name="\u5220\u9664\u63d0\u73b0\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteWithdraw(Integer withdrawId) {
        if (StringUtils.isBlank((Integer)withdrawId)) {
            this.logger.error(CODE + ".deleteWithdraw", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpWithdrawServiceRepository.deleteWithdraw(withdrawId);
    }

    @RequestMapping(value={"queryWithdrawPage.json"}, name="\u67e5\u8be2\u63d0\u73b0\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CpWithdrawReDomain> queryWithdrawPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cpWithdrawServiceRepository.queryWithdrawPage(param);
    }

    @RequestMapping(value={"updateWithdrawState.json"}, name="\u66f4\u65b0\u63d0\u73b0\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateWithdrawState(String withdrawId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)withdrawId)) {
            this.logger.error(CODE + ".updateWithdrawState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cpWithdrawServiceRepository.updateWithdrawState(Integer.valueOf(withdrawId), dataState, oldDataState);
    }
}

