/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.crms.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderGoodsReDomain;
import com.qjsoft.laser.controller.facade.crms.domain.CrmsSOrderReDomain;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsSOrderGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.crms.repository.CrmsSOrderServiceRepository;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/crms/sorder"}, name="\u670d\u52a1\u5355")
public class SOrderCon
extends SpringmvcController {
    private static String CODE = "crms.sorder.con";
    @Autowired
    private CrmsSOrderServiceRepository crmsSOrderServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private CrmsSOrderGoodsServiceRepository crmsSOrderGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;

    protected String getContext() {
        return "sorder";
    }

    @RequestMapping(value={"saveSOrder.json"}, name="\u589e\u52a0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean saveSOrder(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.createOrder(request, orderDomainStr, "00", memberBcode, "1");
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, CrmsSOrderDomain.class);
        this.logger.error(CODE + ".createOrder:orderDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(orderDomainList));
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.crmsSOrderServiceRepository.createOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    public OrgUserBean getOrgUserBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            if (StringUtils.isBlank((String)orgUserBean.getEmployeeCode())) {
                orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
                orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            }
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    private void makeChannel(List<CrmsSOrderDomain> orderDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(orderDomainList) || null == request) {
            return;
        }
        for (CrmsSOrderDomain orderDomain : orderDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    @RequestMapping(value={"getSOrder.json"}, name="\u83b7\u53d6\u670d\u52a1\u5355\u4fe1\u606f")
    @ResponseBody
    public CrmsSOrderReDomain getSOrder(Integer sorderId) {
        if (StringUtils.isBlank((Integer)sorderId)) {
            this.logger.error(CODE + ".getSOrder", (Object)"param is null");
            return null;
        }
        return this.crmsSOrderServiceRepository.getSOrder(sorderId);
    }

    @RequestMapping(value={"updateSOrder.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean updateSOrder(HttpServletRequest request, String orderDomainStr) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".updateSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CrmsSOrderDomain crmsSOrderDomain = (CrmsSOrderDomain)JsonUtil.buildNormalBinder().getJsonToObject(orderDomainStr, CrmsSOrderDomain.class);
        crmsSOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.crmsSOrderServiceRepository.updateSOrder(crmsSOrderDomain);
    }

    @RequestMapping(value={"deleteSOrder.json"}, name="\u5220\u9664\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteSOrder(Integer sorderId) {
        if (StringUtils.isBlank((Integer)sorderId)) {
            this.logger.error(CODE + ".deleteSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.deleteSOrder(sorderId);
    }

    @RequestMapping(value={"querySOrderPage.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderReDomain> querySOrderPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error("param+++", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
        return this.crmsSOrderServiceRepository.querySOrderPage(param);
    }

    @RequestMapping(value={"updateSOrderState.json"}, name="\u66f4\u65b0\u670d\u52a1\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSOrderState(String sorderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)sorderId)) {
            this.logger.error(CODE + ".updateSOrderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.updateSOrderState(Integer.valueOf(sorderId), dataState, oldDataState);
    }

    @RequestMapping(value={"querySOrderGoodsPage.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderGoodsReDomain> querySOrderGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (param.get("queryType") != null) {
            if ("1".equals(param.get("queryType"))) {
                param.put("contractGoodsRefnumQmin", 0);
            } else if ("2".equals(param.get("queryType"))) {
                param.put("contractGoodsSendnumQmin", 0);
            }
        }
        return this.crmsSOrderGoodsServiceRepository.querySOrderGoodsPage(param);
    }

    @RequestMapping(value={"returnOrderGoods.json"}, name="\u9000\u8fd8/\u8f6c\u9500\u8d27\u7269\u6570\u636e\u53d8\u6362\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean returnOrderGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".returnOrderGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.crmsSOrderServiceRepository.returnOrderGoods(this.getTenantCode(request), orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveSOrderRule.json"}, name="\u589e\u52a0\u670d\u52a1\u5355")
    @ResponseBody
    public HtmlJsonReBean saveSOrderRule(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveSOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.createOrderRule(request, orderDomainStr, "00", memberBcode, "1");
    }

    protected HtmlJsonReBean createOrderRule(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, CrmsSOrderDomain.class);
        this.logger.error(CODE + ".createOrder:orderDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(orderDomainList));
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBeanRule(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((CrmsSOrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((CrmsSOrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.crmsSOrderServiceRepository.createOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    public OrgUserBean getOrgUserBeanRule(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        UmUserinfoReDomainBean umUserinfoReDomainBean;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, userSession.getTenantCode()}));
        if (null != umUser && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            this.logger.error(ddFalgSettingReDomain.toString() + "111222");
            this.logger.error(orgUserBean.toString() + "1111111");
            orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
        }
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
            orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    @RequestMapping(value={"querySOrderPageRule.json"}, name="\u67e5\u8be2\u670d\u52a1\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CrmsSOrderReDomain> querySOrderPageRule(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult ocRefundReDomainSupQueryResult = this.crmsSOrderServiceRepository.querySOrderPage(param);
        List crmsURechargeReDomains = ocRefundReDomainSupQueryResult.getList();
        UserSession userSession = this.getUserSession(request);
        for (CrmsSOrderReDomain oc : crmsURechargeReDomains) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{oc.getMemberBcode(), userSession.getTenantCode()}));
            if (null == umUser || !ListUtil.isNotEmpty((Collection)umUser.getList()) || !"1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) continue;
            HashMap<String, String> ddmap = new HashMap<String, String>();
            ddmap.put("flagSettingCode", "exchangerate");
            SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
            DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
            oc.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
        }
        return ocRefundReDomainSupQueryResult;
    }
}

